/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.writers;

import java.util.HashSet;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.util.StaxUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.ws.wss.secext.AttributedString;
import org.picketlink.identity.federation.ws.wss.secext.KeyIdentifierType;
import org.picketlink.identity.federation.ws.wss.secext.SecurityTokenReferenceType;
import org.picketlink.identity.federation.ws.wss.secext.UsernameTokenType;

public class WSSecurityWriter {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private final XMLStreamWriter writer;

    public WSSecurityWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }

    public void write(UsernameTokenType usernameToken) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, "wsse", "UsernameToken", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        StaxUtil.writeNameSpace(this.writer, "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        String id = usernameToken.getId();
        if (StringUtil.isNullOrEmpty(id)) {
            throw logger.nullValueError("Id on the UsernameToken");
        }
        QName wsuIDQName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id", "wsu");
        StaxUtil.writeNameSpace(this.writer, "wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        StaxUtil.writeAttribute(this.writer, wsuIDQName, id);
        AttributedString userNameAttr = usernameToken.getUsername();
        if (userNameAttr == null) {
            throw logger.nullValueError("User Name is null on the UsernameToken");
        }
        StaxUtil.writeStartElement(this.writer, "wsse", "Username", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        StaxUtil.writeCharacters(this.writer, userNameAttr.getValue());
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void writeLifetime(XMLGregorianCalendar created, XMLGregorianCalendar expires) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, "wsu", "Created", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        StaxUtil.writeNameSpace(this.writer, "wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        StaxUtil.writeCharacters(this.writer, created.toXMLFormat());
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.writeStartElement(this.writer, "wsu", "Expires", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        StaxUtil.writeNameSpace(this.writer, "wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        StaxUtil.writeCharacters(this.writer, expires.toXMLFormat());
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void writeSecurityTokenReference(SecurityTokenReferenceType secRef) throws ProcessingException {
        HashSet<String> usedNamespaces = new HashSet<String>();
        usedNamespaces.add("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        StaxUtil.writeStartElement(this.writer, "wsse", "SecurityTokenReference", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        StaxUtil.writeNameSpace(this.writer, "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        if (secRef.getId() != null && secRef.getId() != "") {
            QName wsuIDQName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id", "wsu");
            StaxUtil.writeNameSpace(this.writer, "wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            StaxUtil.writeAttribute(this.writer, wsuIDQName, secRef.getId());
            usedNamespaces.add("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        }
        for (Map.Entry<QName, String> entry : secRef.getOtherAttributes().entrySet()) {
            QName key = entry.getKey();
            if (!usedNamespaces.contains(key.getNamespaceURI())) {
                StaxUtil.writeNameSpace(this.writer, key.getPrefix(), key.getNamespaceURI());
                usedNamespaces.add(key.getNamespaceURI());
            }
            StaxUtil.writeAttribute(this.writer, key, entry.getValue());
        }
        for (Object obj : secRef.getAny()) {
            if (!(obj instanceof KeyIdentifierType)) continue;
            KeyIdentifierType keyId = (KeyIdentifierType)obj;
            StaxUtil.writeStartElement(this.writer, "wsse", "KeyIdentifier", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            StaxUtil.writeAttribute(this.writer, "ValueType", keyId.getValueType());
            StaxUtil.writeCharacters(this.writer, keyId.getValue());
            StaxUtil.writeEndElement(this.writer);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }
}

