/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mod_cluster.undertow;

import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.core.ManagedListener;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionListener;
import org.jboss.modcluster.container.Context;
import org.jboss.modcluster.container.Host;
import org.wildfly.clustering.web.undertow.session.SessionManagerAdapterFactory;

public class UndertowContext
implements Context {
    private Deployment deployment;
    private Host host;

    public UndertowContext(Deployment deployment, Host host) {
        this.deployment = deployment;
        this.host = host;
    }

    public Host getHost() {
        return this.host;
    }

    public String getPath() {
        return this.deployment.getDeploymentInfo().getContextPath();
    }

    public boolean isStarted() {
        return this.deployment.getApplicationListeners().isStarted();
    }

    public void addRequestListener(ServletRequestListener listener) {
        this.deployment.getApplicationListeners().addListener(new ManagedListener(new ListenerInfo(ServletRequestListener.class, (InstanceFactory)new ImmediateInstanceFactory((Object)listener)), true));
    }

    public void removeRequestListener(ServletRequestListener listener) {
    }

    public void addSessionListener(HttpSessionListener listener) {
        this.deployment.getApplicationListeners().addListener(new ManagedListener(new ListenerInfo(HttpSessionListener.class, (InstanceFactory)new ImmediateInstanceFactory((Object)listener)), true));
    }

    public void removeSessionListener(HttpSessionListener listener) {
    }

    public int getActiveSessionCount() {
        return this.deployment.getSessionManager().getActiveSessions().size();
    }

    public boolean isDistributable() {
        return this.deployment.getDeploymentInfo().getSessionManagerFactory() instanceof SessionManagerAdapterFactory;
    }

    public boolean equals(Object object) {
        if (!(object instanceof UndertowContext)) {
            return false;
        }
        UndertowContext context = (UndertowContext)object;
        return this.host.equals(context.host) && this.getPath().equals(context.getPath());
    }

    public int hashCode() {
        return this.host.hashCode() ^ this.getPath().hashCode();
    }
}

