/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.undertow.AbstractListenerAdd;
import org.wildfly.extension.undertow.ListenerRemoveHandler;
import org.wildfly.extension.undertow.UndertowExtension;

abstract class AbstractListenerResourceDefinition
extends PersistentResourceDefinition {
    protected static final SimpleAttributeDefinition SOCKET_BINDING = new SimpleAttributeDefinitionBuilder("socket-binding", ModelType.STRING).setAllowNull(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new StringLengthValidator(1)).build();
    protected static final SimpleAttributeDefinition WORKER = new SimpleAttributeDefinitionBuilder("worker", ModelType.STRING).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new StringLengthValidator(1)).setDefaultValue(new ModelNode("default")).build();
    protected static final SimpleAttributeDefinition BUFFER_POOL = new SimpleAttributeDefinitionBuilder("buffer-pool", ModelType.STRING).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new StringLengthValidator(1)).setDefaultValue(new ModelNode("default")).build();
    protected static final SimpleAttributeDefinition ENABLED = new SimpleAttributeDefinitionBuilder("enabled", ModelType.BOOLEAN).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(true)).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition MAX_POST_SIZE = new SimpleAttributeDefinitionBuilder("max-post-size", ModelType.LONG).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(0)).setAllowExpression(true).build();
    protected static AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{SOCKET_BINDING, WORKER, BUFFER_POOL, ENABLED, MAX_POST_SIZE};

    public AbstractListenerResourceDefinition(PathElement pathElement) {
        super(pathElement, (ResourceDescriptionResolver)UndertowExtension.getResolver(pathElement.getKey()), null, null);
    }

    static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        super.registerAddOperation(resourceRegistration, (AbstractAddStepHandler)this.getAddHandler(), new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_NONE});
        super.registerRemoveOperation(resourceRegistration, (AbstractRemoveStepHandler)new ListenerRemoveHandler(this.getAddHandler()), new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_NONE});
    }

    protected abstract AbstractListenerAdd getAddHandler();
}

