/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.messaging.AddressSettingDefinition;
import org.jboss.as.messaging.BridgeDefinition;
import org.jboss.as.messaging.BroadcastGroupDefinition;
import org.jboss.as.messaging.ClusterConnectionDefinition;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.DiscoveryGroupDefinition;
import org.jboss.as.messaging.DivertDefinition;
import org.jboss.as.messaging.GroupingHandlerDefinition;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.QueueDefinition;
import org.jboss.as.messaging.RemoteTransportDefinition;
import org.jboss.as.messaging.jms.ConnectionFactoryAttributes;
import org.jboss.as.messaging.jms.bridge.JMSBridgeDefinition;

public enum Element {
    UNKNOWN((String)null),
    ACCEPTORS("acceptors"),
    ADDRESS(Element.getAttributeDefinitions(new AttributeDefinition[]{QueueDefinition.ADDRESS, DivertDefinition.ADDRESS, GroupingHandlerDefinition.GROUPING_HANDLER_ADDRESS, ClusterConnectionDefinition.ADDRESS})),
    ADDRESS_SETTINGS("address-settings"),
    ALLOW_FAILBACK((AttributeDefinition)CommonAttributes.ALLOW_FAILBACK),
    ASYNC_CONNECTION_EXECUTION_ENABLED((AttributeDefinition)CommonAttributes.ASYNC_CONNECTION_EXECUTION_ENABLED),
    BACKUP((AttributeDefinition)CommonAttributes.BACKUP),
    BINDINGS_DIRECTORY("bindings-directory"),
    BRIDGE("bridge"),
    BRIDGES("bridges"),
    BROADCAST_GROUP("broadcast-group"),
    BROADCAST_GROUPS("broadcast-groups"),
    BROADCAST_PERIOD((AttributeDefinition)BroadcastGroupDefinition.BROADCAST_PERIOD),
    CHECK_FOR_LIVE_SERVER((AttributeDefinition)CommonAttributes.CHECK_FOR_LIVE_SERVER),
    CLASS_NAME("class-name"),
    CLUSTERED((AttributeDefinition)CommonAttributes.CLUSTERED),
    CLUSTER_CONNECTION("cluster-connection"),
    CLUSTER_CONNECTIONS("cluster-connections"),
    CLUSTER_PASSWORD((AttributeDefinition)CommonAttributes.CLUSTER_PASSWORD),
    CLUSTER_USER((AttributeDefinition)CommonAttributes.CLUSTER_USER),
    CONNECTION_TTL_OVERRIDE((AttributeDefinition)CommonAttributes.CONNECTION_TTL_OVERRIDE),
    CONNECTOR_SERVICE("connector-service"),
    CONNECTOR_SERVICES("connector-services"),
    CONNECTOR_REF(Element.getConnectorRefDefinitions()),
    CORE_QUEUES("core-queues"),
    CREATE_BINDINGS_DIR((AttributeDefinition)CommonAttributes.CREATE_BINDINGS_DIR),
    CREATE_JOURNAL_DIR((AttributeDefinition)CommonAttributes.CREATE_JOURNAL_DIR),
    DISCOVERY_GROUP("discovery-group"),
    DISCOVERY_GROUPS("discovery-groups"),
    DIVERT("divert"),
    DIVERTS("diverts"),
    DURABLE((AttributeDefinition)CommonAttributes.DURABLE),
    EXCLUSIVE((AttributeDefinition)DivertDefinition.EXCLUSIVE),
    FAILBACK_DELAY((AttributeDefinition)CommonAttributes.FAILBACK_DELAY),
    FAILOVER_ON_SHUTDOWN((AttributeDefinition)CommonAttributes.FAILOVER_ON_SHUTDOWN),
    FILE_DEPLOYMENT_ENABLED("file-deployment-enabled"),
    FORWARDING_ADDRESS(Element.getForwardingAddressDefinitions()),
    FORWARD_WHEN_NO_CONSUMERS((AttributeDefinition)ClusterConnectionDefinition.FORWARD_WHEN_NO_CONSUMERS),
    GROUP_ADDRESS((AttributeDefinition)CommonAttributes.GROUP_ADDRESS),
    GROUP_PORT((AttributeDefinition)CommonAttributes.GROUP_PORT),
    GROUPING_HANDLER("grouping-handler"),
    HORNETQ_SERVER("hornetq-server"),
    SERVLET_CONNECTOR("servlet-connector"),
    ID_CACHE_SIZE((AttributeDefinition)CommonAttributes.ID_CACHE_SIZE),
    INITIAL_WAIT_TIMEOUT((AttributeDefinition)DiscoveryGroupDefinition.INITIAL_WAIT_TIMEOUT),
    IN_VM_ACCEPTOR("in-vm-acceptor"),
    IN_VM_CONNECTOR("in-vm-connector"),
    JGROUPS_CHANNEL((AttributeDefinition)CommonAttributes.JGROUPS_CHANNEL),
    JGROUPS_STACK((AttributeDefinition)CommonAttributes.JGROUPS_STACK),
    JMX_DOMAIN((AttributeDefinition)CommonAttributes.JMX_DOMAIN),
    JMX_MANAGEMENT_ENABLED((AttributeDefinition)CommonAttributes.JMX_MANAGEMENT_ENABLED),
    JOURNAL_BUFFER_SIZE((AttributeDefinition)CommonAttributes.JOURNAL_BUFFER_SIZE),
    JOURNAL_BUFFER_TIMEOUT((AttributeDefinition)CommonAttributes.JOURNAL_BUFFER_TIMEOUT),
    JOURNAL_COMPACT_MIN_FILES((AttributeDefinition)CommonAttributes.JOURNAL_COMPACT_MIN_FILES),
    JOURNAL_COMPACT_PERCENTAGE((AttributeDefinition)CommonAttributes.JOURNAL_COMPACT_PERCENTAGE),
    JOURNAL_DIRECTORY("journal-directory"),
    JOURNAL_FILE_SIZE((AttributeDefinition)CommonAttributes.JOURNAL_FILE_SIZE),
    JOURNAL_MAX_IO((AttributeDefinition)CommonAttributes.JOURNAL_MAX_IO),
    JOURNAL_MIN_FILES((AttributeDefinition)CommonAttributes.JOURNAL_MIN_FILES),
    JOURNAL_SYNC_NON_TRANSACTIONAL((AttributeDefinition)CommonAttributes.JOURNAL_SYNC_NON_TRANSACTIONAL),
    JOURNAL_SYNC_TRANSACTIONAL((AttributeDefinition)CommonAttributes.JOURNAL_SYNC_TRANSACTIONAL),
    JOURNAL_TYPE((AttributeDefinition)CommonAttributes.JOURNAL_TYPE),
    LARGE_MESSAGES_DIRECTORY("large-messages-directory"),
    LIVE_CONNECTOR_REF(CommonAttributes.LIVE_CONNECTOR_REF),
    LOCAL_BIND_ADDRESS((AttributeDefinition)CommonAttributes.LOCAL_BIND_ADDRESS),
    LOCAL_BIND_PORT((AttributeDefinition)CommonAttributes.LOCAL_BIND_PORT),
    LOG_JOURNAL_WRITE_RATE((AttributeDefinition)CommonAttributes.LOG_JOURNAL_WRITE_RATE),
    MANAGEMENT_ADDRESS((AttributeDefinition)CommonAttributes.MANAGEMENT_ADDRESS),
    MANAGEMENT_NOTIFICATION_ADDRESS((AttributeDefinition)CommonAttributes.MANAGEMENT_NOTIFICATION_ADDRESS),
    MAX_HOPS((AttributeDefinition)ClusterConnectionDefinition.MAX_HOPS),
    MEMORY_MEASURE_INTERVAL((AttributeDefinition)CommonAttributes.MEMORY_MEASURE_INTERVAL),
    MEMORY_WARNING_THRESHOLD((AttributeDefinition)CommonAttributes.MEMORY_WARNING_THRESHOLD),
    MESSAGE_COUNTER_ENABLED((AttributeDefinition)CommonAttributes.MESSAGE_COUNTER_ENABLED),
    MESSAGE_COUNTER_MAX_DAY_HISTORY((AttributeDefinition)CommonAttributes.MESSAGE_COUNTER_MAX_DAY_HISTORY),
    MESSAGE_COUNTER_SAMPLE_PERIOD((AttributeDefinition)CommonAttributes.MESSAGE_COUNTER_SAMPLE_PERIOD),
    MESSAGE_EXPIRY_SCAN_PERIOD((AttributeDefinition)CommonAttributes.MESSAGE_EXPIRY_SCAN_PERIOD),
    MESSAGE_EXPIRY_THREAD_PRIORITY((AttributeDefinition)CommonAttributes.MESSAGE_EXPIRY_THREAD_PRIORITY),
    NAME("name"),
    NETTY_ACCEPTOR("netty-acceptor"),
    NETTY_CONNECTOR("netty-connector"),
    BACKUP_GROUP_NAME(CommonAttributes.BACKUP_GROUP_NAME),
    PAGE_MAX_CONCURRENT_IO((AttributeDefinition)CommonAttributes.PAGE_MAX_CONCURRENT_IO),
    PAGING_DIRECTORY("paging-directory"),
    PERF_BLAST_PAGES((AttributeDefinition)CommonAttributes.PERF_BLAST_PAGES),
    PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY((AttributeDefinition)CommonAttributes.PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY),
    PERSIST_ID_CACHE((AttributeDefinition)CommonAttributes.PERSIST_ID_CACHE),
    PERSISTENCE_ENABLED((AttributeDefinition)CommonAttributes.PERSISTENCE_ENABLED),
    QUEUE("queue"),
    REFRESH_TIMEOUT((AttributeDefinition)DiscoveryGroupDefinition.REFRESH_TIMEOUT),
    REMOTING_INTERCEPTORS((AttributeDefinition)CommonAttributes.REMOTING_INTERCEPTORS),
    REMOTING_INCOMING_INTERCEPTORS((AttributeDefinition)CommonAttributes.REMOTING_INCOMING_INTERCEPTORS),
    REMOTING_OUTGOING_INTERCEPTORS((AttributeDefinition)CommonAttributes.REMOTING_OUTGOING_INTERCEPTORS),
    REPLICATION_CLUSTERNAME((AttributeDefinition)CommonAttributes.REPLICATION_CLUSTERNAME),
    ROUTING_NAME((AttributeDefinition)DivertDefinition.ROUTING_NAME),
    RUN_SYNC_SPEED_TEST((AttributeDefinition)CommonAttributes.RUN_SYNC_SPEED_TEST),
    SECURITY_DOMAIN((AttributeDefinition)CommonAttributes.SECURITY_DOMAIN),
    SECURITY_ENABLED((AttributeDefinition)CommonAttributes.SECURITY_ENABLED),
    SECURITY_INVALIDATION_INTERVAL((AttributeDefinition)CommonAttributes.SECURITY_INVALIDATION_INTERVAL),
    SECURITY_SETTINGS("security-settings"),
    SERVER_DUMP_INTERVAL((AttributeDefinition)CommonAttributes.SERVER_DUMP_INTERVAL),
    SHARED_STORE((AttributeDefinition)CommonAttributes.SHARED_STORE),
    SUBSYSTEM("subsystem"),
    TRANSACTION_TIMEOUT((AttributeDefinition)CommonAttributes.TRANSACTION_TIMEOUT),
    TRANSACTION_TIMEOUT_SCAN_PERIOD((AttributeDefinition)CommonAttributes.TRANSACTION_TIMEOUT_SCAN_PERIOD),
    TRANSFORMER_CLASS_NAME((AttributeDefinition)CommonAttributes.TRANSFORMER_CLASS_NAME),
    WILD_CARD_ROUTING_ENABLED((AttributeDefinition)CommonAttributes.WILD_CARD_ROUTING_ENABLED),
    ACCEPTOR("acceptor"),
    CONNECTORS("connectors"),
    CONNECTOR("connector"),
    FACTORY_CLASS((AttributeDefinition)CommonAttributes.FACTORY_CLASS),
    FILTER((AttributeDefinition)CommonAttributes.FILTER),
    PARAM("param"),
    SECURITY_SETTING("security-setting"),
    PERMISSION_ELEMENT_NAME("permission"),
    ADDRESS_SETTING("address-setting"),
    DEAD_LETTER_ADDRESS((AttributeDefinition)CommonAttributes.DEAD_LETTER_ADDRESS),
    EXPIRY_ADDRESS((AttributeDefinition)CommonAttributes.EXPIRY_ADDRESS),
    EXPIRY_DELAY((AttributeDefinition)AddressSettingDefinition.EXPIRY_DELAY),
    REDELIVERY_DELAY((AttributeDefinition)AddressSettingDefinition.REDELIVERY_DELAY),
    MAX_DELIVERY_ATTEMPTS((AttributeDefinition)AddressSettingDefinition.MAX_DELIVERY_ATTEMPTS),
    MAX_SIZE_BYTES((AttributeDefinition)AddressSettingDefinition.MAX_SIZE_BYTES),
    ADDRESS_FULL_MESSAGE_POLICY((AttributeDefinition)AddressSettingDefinition.ADDRESS_FULL_MESSAGE_POLICY),
    PAGE_MAX_CACHE_SIZE((AttributeDefinition)AddressSettingDefinition.PAGE_MAX_CACHE_SIZE),
    PAGE_SIZE_BYTES((AttributeDefinition)AddressSettingDefinition.PAGE_SIZE_BYTES),
    MESSAGE_COUNTER_HISTORY_DAY_LIMIT((AttributeDefinition)AddressSettingDefinition.MESSAGE_COUNTER_HISTORY_DAY_LIMIT),
    LVQ((AttributeDefinition)AddressSettingDefinition.LAST_VALUE_QUEUE),
    REDISTRIBUTION_DELAY((AttributeDefinition)AddressSettingDefinition.REDISTRIBUTION_DELAY),
    SEND_TO_DLA_ON_NO_ROUTE((AttributeDefinition)AddressSettingDefinition.SEND_TO_DLA_ON_NO_ROUTE),
    STATIC_CONNECTORS("static-connectors"),
    TIMEOUT((AttributeDefinition)GroupingHandlerDefinition.TIMEOUT),
    TYPE((AttributeDefinition)GroupingHandlerDefinition.TYPE),
    AUTO_GROUP(ConnectionFactoryAttributes.Common.AUTO_GROUP),
    BLOCK_ON_ACK(ConnectionFactoryAttributes.Common.BLOCK_ON_ACKNOWLEDGE),
    BLOCK_ON_DURABLE_SEND(ConnectionFactoryAttributes.Common.BLOCK_ON_DURABLE_SEND),
    BLOCK_ON_NON_DURABLE_SEND(ConnectionFactoryAttributes.Common.BLOCK_ON_NON_DURABLE_SEND),
    CACHE_LARGE_MESSAGE_CLIENT(ConnectionFactoryAttributes.Common.CACHE_LARGE_MESSAGE_CLIENT),
    CALL_TIMEOUT(CommonAttributes.CALL_TIMEOUT),
    CALL_FAILOVER_TIMEOUT((AttributeDefinition)CommonAttributes.CALL_FAILOVER_TIMEOUT),
    CHECK_PERIOD(Element.getCheckPeriodDefinitions()),
    CLIENT_FAILURE_CHECK_PERIOD(ConnectionFactoryAttributes.Common.CLIENT_FAILURE_CHECK_PERIOD),
    CLIENT_ID(CommonAttributes.CLIENT_ID),
    CONNECTION_FACTORY(Element.getConnectionFactoryDefinitions()),
    CONNECTION_FACTORIES("jms-connection-factories"),
    CONNECTION_TTL(Element.getConnectionTTLDefinitions()),
    CONFIRMATION_WINDOW_SIZE(Element.getConfirmationWindowSizeDefinitions()),
    CONSUMER_MAX_RATE(ConnectionFactoryAttributes.Common.CONSUMER_MAX_RATE),
    CONSUMER_WINDOW_SIZE(ConnectionFactoryAttributes.Common.CONSUMER_WINDOW_SIZE),
    DISCOVERY_INITIAL_WAIT_TIMEOUT(ConnectionFactoryAttributes.Common.DISCOVERY_INITIAL_WAIT_TIMEOUT),
    DISCOVERY_GROUP_REF("discovery-group-ref"),
    DUPS_OK_BATCH_SIZE(ConnectionFactoryAttributes.Common.DUPS_OK_BATCH_SIZE),
    ENTRIES((AttributeDefinition)ConnectionFactoryAttributes.Common.ENTRIES),
    ENTRY("entry"),
    FAILOVER_ON_INITIAL_CONNECTION(ConnectionFactoryAttributes.Common.FAILOVER_ON_INITIAL_CONNECTION),
    FAILOVER_ON_SERVER_SHUTDOWN(ConnectionFactoryAttributes.Common.FAILOVER_ON_SERVER_SHUTDOWN),
    GROUP_ID(ConnectionFactoryAttributes.Common.GROUP_ID),
    HA((AttributeDefinition)CommonAttributes.HA),
    INITIAL_CONNECT_ATTEMPTS((AttributeDefinition)ConnectionFactoryAttributes.Pooled.INITIAL_CONNECT_ATTEMPTS),
    INITIAL_MESSAGE_PACKET_SIZE((AttributeDefinition)ConnectionFactoryAttributes.Pooled.INITIAL_MESSAGE_PACKET_SIZE),
    JMS_DESTINATIONS("jms-destinations"),
    JMS_TOPIC("jms-topic"),
    JMS_QUEUE("jms-queue"),
    LOAD_BALANCING_CLASS_NAME(ConnectionFactoryAttributes.Common.CONNECTION_LOAD_BALANCING_CLASS_NAME),
    MAX_POOL_SIZE((AttributeDefinition)ConnectionFactoryAttributes.Pooled.MAX_POOL_SIZE),
    MAX_RETRY_INTERVAL(Element.getMaxRetryIntervalDefinitions()),
    MIN_LARGE_MESSAGE_SIZE(Element.getMinLargeMessageSizeDefinitions()),
    MIN_POOL_SIZE((AttributeDefinition)ConnectionFactoryAttributes.Pooled.MIN_POOL_SIZE),
    NOTIFICATION_ATTEMPTS((AttributeDefinition)ClusterConnectionDefinition.NOTIFICATION_ATTEMPTS),
    NOTIFICATION_INTERVAL((AttributeDefinition)ClusterConnectionDefinition.NOTIFICATION_INTERVAL),
    PASSWORD(Element.getPasswordDefinitions()),
    PRE_ACK(ConnectionFactoryAttributes.Common.PRE_ACKNOWLEDGE),
    PRODUCER_WINDOW_SIZE(ConnectionFactoryAttributes.Common.PRODUCER_WINDOW_SIZE),
    PRODUCER_MAX_RATE(ConnectionFactoryAttributes.Common.PRODUCER_MAX_RATE),
    QUEUE_NAME((AttributeDefinition)BridgeDefinition.QUEUE_NAME),
    RECONNECT_ATTEMPTS(Element.getReconnectAttemptsDefinitions()),
    RECONNECT_ATTEMPTS_ON_SAME_NODE((AttributeDefinition)BridgeDefinition.RECONNECT_ATTEMPTS_ON_SAME_NODE),
    RETRY_INTERVAL(Element.getRetryIntervalDefinitions()),
    RETRY_INTERVAL_MULTIPLIER(Element.getRetryIntervalMultiplierDefinitions()),
    SELECTOR((AttributeDefinition)CommonAttributes.SELECTOR),
    SCHEDULED_THREAD_POOL_MAX_SIZE(Element.getScheduledThreadPoolDefinitions()),
    THREAD_POOL_MAX_SIZE(Element.getThreadPoolDefinitions()),
    TRANSACTION_BATH_SIZE(ConnectionFactoryAttributes.Common.TRANSACTION_BATCH_SIZE),
    USER(Element.getUserDefinitions()),
    USE_DUPLICATE_DETECTION(Element.getDuplicateDetectionDefinitions()),
    USE_AUTO_RECOVERY(ConnectionFactoryAttributes.Pooled.USE_AUTO_RECOVERY),
    USE_GLOBAL_POOLS(ConnectionFactoryAttributes.Common.USE_GLOBAL_POOLS),
    POOLED_CONNECTION_FACTORY("pooled-connection-factory"),
    TRANSACTION((AttributeDefinition)ConnectionFactoryAttributes.Pooled.TRANSACTION),
    MODE("mode"),
    INBOUND_CONFIG("inbound-config"),
    USE_JNDI(ConnectionFactoryAttributes.Pooled.USE_JNDI),
    JNDI_PARAMS((AttributeDefinition)ConnectionFactoryAttributes.Pooled.JNDI_PARAMS),
    USE_LOCAL_TX(ConnectionFactoryAttributes.Pooled.USE_LOCAL_TX),
    COMPRESS_LARGE_MESSAGES(ConnectionFactoryAttributes.Common.COMPRESS_LARGE_MESSAGES),
    CONNECTION_FACTORY_TYPE(ConnectionFactoryAttributes.Regular.FACTORY_TYPE),
    SETUP_ATTEMPTS((AttributeDefinition)ConnectionFactoryAttributes.Pooled.SETUP_ATTEMPTS),
    SETUP_INTERVAL((AttributeDefinition)ConnectionFactoryAttributes.Pooled.SETUP_INTERVAL),
    SOCKET_BINDING(RemoteTransportDefinition.SOCKET_BINDING.getName()),
    JMS_BRIDGE("jms-bridge"),
    SOURCE("source"),
    TARGET("target"),
    DESTINATION(Element.getDestinationDefinitions()),
    CONTEXT(Element.getContextDefinitions()),
    PROPERTY("property"),
    QUALITY_OF_SERVICE((AttributeDefinition)JMSBridgeDefinition.QUALITY_OF_SERVICE),
    FAILURE_RETRY_INTERVAL((AttributeDefinition)JMSBridgeDefinition.FAILURE_RETRY_INTERVAL),
    MAX_RETRIES((AttributeDefinition)JMSBridgeDefinition.MAX_RETRIES),
    MAX_BATCH_SIZE((AttributeDefinition)JMSBridgeDefinition.MAX_BATCH_SIZE),
    MAX_BATCH_TIME((AttributeDefinition)JMSBridgeDefinition.MAX_BATCH_TIME),
    SUBSCRIPTION_NAME((AttributeDefinition)JMSBridgeDefinition.SUBSCRIPTION_NAME),
    ADD_MESSAGE_ID_IN_HEADER((AttributeDefinition)JMSBridgeDefinition.ADD_MESSAGE_ID_IN_HEADER),
    MODULE((AttributeDefinition)JMSBridgeDefinition.MODULE);

    private final String name;
    private final AttributeDefinition definition;
    private final Map<String, AttributeDefinition> definitions;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
        this.definition = null;
        this.definitions = null;
    }

    private Element(AttributeDefinition definition) {
        this.name = definition.getXmlName();
        this.definition = definition;
        this.definitions = null;
    }

    private Element(List<AttributeDefinition> definitions) {
        this.definition = null;
        this.definitions = new HashMap<String, AttributeDefinition>();
        String ourName = null;
        for (AttributeDefinition def : definitions) {
            if (ourName == null) {
                ourName = def.getXmlName();
            } else if (!ourName.equals(def.getXmlName())) {
                throw MessagingMessages.MESSAGES.attributeDefinitionsMustMatch(def.getXmlName(), ourName);
            }
            if (this.definitions.put(def.getName(), def) == null) continue;
            throw MessagingMessages.MESSAGES.attributeDefinitionsNotUnique(def.getName());
        }
        this.name = ourName;
    }

    private Element(Map<String, AttributeDefinition> definitions) {
        this.definition = null;
        this.definitions = new HashMap<String, AttributeDefinition>();
        String ourName = null;
        for (Map.Entry<String, AttributeDefinition> def : definitions.entrySet()) {
            String xmlName = def.getValue().getXmlName();
            if (ourName == null) {
                ourName = xmlName;
            } else if (!ourName.equals(xmlName)) {
                throw MessagingMessages.MESSAGES.attributeDefinitionsMustMatch(xmlName, ourName);
            }
            this.definitions.put(def.getKey(), def.getValue());
        }
        this.name = ourName;
    }

    public String getLocalName() {
        return this.name;
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    public AttributeDefinition getDefinition(String name) {
        return this.definitions.get(name);
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    private static List<AttributeDefinition> getAttributeDefinitions(AttributeDefinition ... attributeDefinitions) {
        return Arrays.asList(attributeDefinitions);
    }

    private static Map<String, AttributeDefinition> getScheduledThreadPoolDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("server", CommonAttributes.SCHEDULED_THREAD_POOL_MAX_SIZE);
        result.put("connection", ConnectionFactoryAttributes.Common.SCHEDULED_THREAD_POOL_MAX_SIZE);
        return result;
    }

    private static Map<String, AttributeDefinition> getThreadPoolDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("server", CommonAttributes.THREAD_POOL_MAX_SIZE);
        result.put("connection", ConnectionFactoryAttributes.Common.THREAD_POOL_MAX_SIZE);
        return result;
    }

    private static Map<String, AttributeDefinition> getConnectorRefDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("simple", (AttributeDefinition)ClusterConnectionDefinition.CONNECTOR_REF);
        result.put("broadcast-group", (AttributeDefinition)BroadcastGroupDefinition.CONNECTOR_REFS);
        result.put("bridge", (AttributeDefinition)BridgeDefinition.CONNECTOR_REFS);
        result.put("cluster-connection", (AttributeDefinition)ClusterConnectionDefinition.CONNECTOR_REFS);
        return result;
    }

    private static Map<String, AttributeDefinition> getReconnectAttemptsDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("connection", ConnectionFactoryAttributes.Common.RECONNECT_ATTEMPTS);
        result.put("pooled-connection", ConnectionFactoryAttributes.Pooled.RECONNECT_ATTEMPTS);
        result.put("bridge", (AttributeDefinition)BridgeDefinition.RECONNECT_ATTEMPTS);
        result.put("cluster", (AttributeDefinition)ClusterConnectionDefinition.RECONNECT_ATTEMPTS);
        return result;
    }

    private static Map<String, AttributeDefinition> getConfirmationWindowSizeDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("connection", ConnectionFactoryAttributes.Common.CONFIRMATION_WINDOW_SIZE);
        result.put("bridge", (AttributeDefinition)CommonAttributes.BRIDGE_CONFIRMATION_WINDOW_SIZE);
        return result;
    }

    private static Map<String, AttributeDefinition> getForwardingAddressDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("divert", (AttributeDefinition)DivertDefinition.FORWARDING_ADDRESS);
        result.put("bridge", (AttributeDefinition)BridgeDefinition.FORWARDING_ADDRESS);
        return result;
    }

    private static Map<String, AttributeDefinition> getDuplicateDetectionDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("cluster", (AttributeDefinition)ClusterConnectionDefinition.USE_DUPLICATE_DETECTION);
        result.put("bridge", (AttributeDefinition)BridgeDefinition.USE_DUPLICATE_DETECTION);
        return result;
    }

    private static Map<String, AttributeDefinition> getRetryIntervalDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("cluster", (AttributeDefinition)ClusterConnectionDefinition.RETRY_INTERVAL);
        result.put("connection", ConnectionFactoryAttributes.Common.RETRY_INTERVAL);
        result.put("default", CommonAttributes.RETRY_INTERVAL);
        return result;
    }

    private static Map<String, AttributeDefinition> getRetryIntervalMultiplierDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("cluster", (AttributeDefinition)ClusterConnectionDefinition.RETRY_INTERVAL_MULTIPLIER);
        result.put("connection", ConnectionFactoryAttributes.Common.RETRY_INTERVAL_MULTIPLIER);
        result.put("default", CommonAttributes.RETRY_INTERVAL_MULTIPLIER);
        return result;
    }

    private static Map<String, AttributeDefinition> getMaxRetryIntervalDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("cluster", (AttributeDefinition)ClusterConnectionDefinition.MAX_RETRY_INTERVAL);
        result.put("connection", ConnectionFactoryAttributes.Common.MAX_RETRY_INTERVAL);
        result.put("default", CommonAttributes.MAX_RETRY_INTERVAL);
        return result;
    }

    private static Map<String, AttributeDefinition> getMinLargeMessageSizeDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("connection", ConnectionFactoryAttributes.Common.MIN_LARGE_MESSAGE_SIZE);
        result.put("default", CommonAttributes.MIN_LARGE_MESSAGE_SIZE);
        return result;
    }

    private static Map<String, AttributeDefinition> getConnectionTTLDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("cluster", (AttributeDefinition)ClusterConnectionDefinition.CONNECTION_TTL);
        result.put("connection", ConnectionFactoryAttributes.Common.CONNECTION_TTL);
        result.put("default", (AttributeDefinition)CommonAttributes.CONNECTION_TTL);
        return result;
    }

    private static Map<String, AttributeDefinition> getCheckPeriodDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("cluster", (AttributeDefinition)ClusterConnectionDefinition.CHECK_PERIOD);
        result.put("default", (AttributeDefinition)CommonAttributes.CHECK_PERIOD);
        return result;
    }

    private static Map<String, AttributeDefinition> getUserDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("source", (AttributeDefinition)JMSBridgeDefinition.SOURCE_USER);
        result.put("target", (AttributeDefinition)JMSBridgeDefinition.TARGET_USER);
        result.put("default", (AttributeDefinition)BridgeDefinition.USER);
        return result;
    }

    private static Map<String, AttributeDefinition> getPasswordDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("source", (AttributeDefinition)JMSBridgeDefinition.SOURCE_PASSWORD);
        result.put("target", (AttributeDefinition)JMSBridgeDefinition.TARGET_PASSWORD);
        result.put("default", (AttributeDefinition)BridgeDefinition.PASSWORD);
        return result;
    }

    private static Map<String, AttributeDefinition> getConnectionFactoryDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("source", (AttributeDefinition)JMSBridgeDefinition.SOURCE_CONNECTION_FACTORY);
        result.put("target", (AttributeDefinition)JMSBridgeDefinition.TARGET_CONNECTION_FACTORY);
        return result;
    }

    private static Map<String, AttributeDefinition> getDestinationDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("source", (AttributeDefinition)JMSBridgeDefinition.SOURCE_DESTINATION);
        result.put("target", (AttributeDefinition)JMSBridgeDefinition.TARGET_DESTINATION);
        return result;
    }

    private static Map<String, AttributeDefinition> getContextDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("source", (AttributeDefinition)JMSBridgeDefinition.SOURCE_CONTEXT);
        result.put("target", (AttributeDefinition)JMSBridgeDefinition.TARGET_CONTEXT);
        return result;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

