/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.deployment;

import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.Queue;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.deployment.MessagingJMSDestinationManagedReferenceFactory;
import org.jboss.as.messaging.deployment.MessagingXmlInstallDeploymentUnitProcessor;
import org.jboss.as.messaging.jms.JMSQueueConfigurationRuntimeHandler;
import org.jboss.as.messaging.jms.JMSQueueService;
import org.jboss.as.messaging.jms.JMSTopicConfigurationRuntimeHandler;
import org.jboss.as.messaging.jms.JMSTopicService;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class DirectJMSDestinationInjectionSource
extends InjectionSource {
    private final String name;
    private final String interfaceName;
    private String description;
    private String className;
    private String resourceAdapter;
    private String destinationName;
    private Map<String, String> properties = new HashMap<String, String>();

    public DirectJMSDestinationInjectionSource(String name, String interfaceName) {
        this.name = name;
        this.interfaceName = interfaceName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setResourceAdapter(String resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    private String uniqueName(InjectionSource.ResolutionContext context, String jndiName) {
        StringBuilder uniqueName = new StringBuilder();
        uniqueName.append(context.getApplicationName() + "_");
        uniqueName.append(context.getModuleName() + "_");
        if (context.getComponentName() != null) {
            uniqueName.append(context.getComponentName() + "_");
        }
        uniqueName.append(jndiName);
        return uniqueName.toString();
    }

    public void getResourceValue(InjectionSource.ResolutionContext context, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        String uniqueName = this.destinationName != null ? this.destinationName : this.uniqueName(context, this.name);
        try {
            ServiceName hqServiceName = MessagingServices.getHornetQServiceName(this.getHornetQServerName());
            if (this.interfaceName.equals(Queue.class.getName())) {
                this.startQueue(context, uniqueName, phaseContext.getServiceTarget(), hqServiceName, serviceBuilder, deploymentUnit, injector);
            } else {
                this.startTopic(context, uniqueName, phaseContext.getServiceTarget(), hqServiceName, serviceBuilder, deploymentUnit, injector);
            }
        }
        catch (Exception e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    private void startQueue(InjectionSource.ResolutionContext context, String queueName, ServiceTarget serviceTarget, ServiceName hqServiceName, ServiceBuilder<?> serviceBuilder, DeploymentUnit deploymentUnit, Injector<ManagedReferenceFactory> injector) {
        String selector = this.properties.containsKey(CommonAttributes.SELECTOR.getName()) ? this.properties.get(CommonAttributes.SELECTOR.getName()) : null;
        boolean durable = this.properties.containsKey(CommonAttributes.DURABLE.getName()) ? Boolean.valueOf(this.properties.get(CommonAttributes.DURABLE.getName())).booleanValue() : CommonAttributes.DURABLE.getDefaultValue().asBoolean();
        ModelNode destination = new ModelNode();
        destination.get("name").set(queueName);
        destination.get(CommonAttributes.DURABLE.getName()).set(durable);
        if (selector != null) {
            destination.get(CommonAttributes.SELECTOR.getName()).set(selector);
        }
        destination.get("entries").add(this.name);
        Service<Queue> queueService = JMSQueueService.installService(null, null, queueName, serviceTarget, hqServiceName, selector, durable, new String[0]);
        this.bindDestination(context, serviceTarget, serviceBuilder, injector, queueService);
        PathElement serverElement = PathElement.pathElement((String)"hornetq-server", (String)this.getHornetQServerName());
        PathElement dest = PathElement.pathElement((String)"jms-queue", (String)this.destinationName);
        deploymentUnit.createDeploymentSubModel("messaging", serverElement);
        PathAddress registration = PathAddress.pathAddress((PathElement[])new PathElement[]{serverElement, dest});
        MessagingXmlInstallDeploymentUnitProcessor.createDeploymentSubModel(registration, deploymentUnit);
        JMSQueueConfigurationRuntimeHandler.INSTANCE.registerDestination(this.getHornetQServerName(), queueName, destination);
    }

    private void startTopic(InjectionSource.ResolutionContext context, String topicName, ServiceTarget serviceTarget, ServiceName hqServiceName, ServiceBuilder<?> serviceBuilder, DeploymentUnit deploymentUnit, Injector<ManagedReferenceFactory> injector) {
        ModelNode destination = new ModelNode();
        destination.get("name").set(topicName);
        destination.get("entries").add(this.name);
        JMSTopicService topicService = JMSTopicService.installService(null, null, topicName, hqServiceName, serviceTarget, new String[0]);
        this.bindDestination(context, serviceTarget, serviceBuilder, injector, topicService);
        PathElement serverElement = PathElement.pathElement((String)"hornetq-server", (String)this.getHornetQServerName());
        PathElement dest = PathElement.pathElement((String)"jms-topic", (String)this.destinationName);
        deploymentUnit.createDeploymentSubModel("messaging", serverElement);
        PathAddress registration = PathAddress.pathAddress((PathElement[])new PathElement[]{serverElement, dest});
        MessagingXmlInstallDeploymentUnitProcessor.createDeploymentSubModel(registration, deploymentUnit);
        JMSTopicConfigurationRuntimeHandler.INSTANCE.registerDestination(this.getHornetQServerName(), topicName, destination);
    }

    private <D extends Destination> void bindDestination(InjectionSource.ResolutionContext context, ServiceTarget serviceTarget, ServiceBuilder<?> serviceBuilder, Injector<ManagedReferenceFactory> injector, Service<D> destinationService) {
        MessagingJMSDestinationManagedReferenceFactory<D> referenceFactoryService = new MessagingJMSDestinationManagedReferenceFactory<D>(destinationService);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)context.getApplicationName(), (String)context.getModuleName(), (String)context.getComponentName(), (!context.isCompUsesModule() ? 1 : 0) != 0, (String)this.name);
        BinderService binderService = new BinderService(bindInfo.getBindName(), (Object)this);
        ServiceBuilder binderBuilder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addInjection(binderService.getManagedObjectInjector(), referenceFactoryService).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector()).addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                switch (transition) {
                    case STARTING_to_UP: {
                        MessagingLogger.ROOT_LOGGER.boundJndiName(DirectJMSDestinationInjectionSource.this.name);
                        break;
                    }
                    case START_REQUESTED_to_DOWN: {
                        MessagingLogger.ROOT_LOGGER.unboundJndiName(DirectJMSDestinationInjectionSource.this.name);
                        break;
                    }
                    case REMOVING_to_REMOVED: {
                        MessagingLogger.ROOT_LOGGER.debugf("Removed messaging object [%s]", DirectJMSDestinationInjectionSource.this.name);
                    }
                }
            }
        });
        binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        serviceBuilder.addDependency(bindInfo.getBinderServiceName(), ManagedReferenceFactory.class, injector);
    }

    private String getHornetQServerName() {
        return this.properties.containsKey("hornetq-server") ? this.properties.get("hornetq-server") : "default";
    }
}

