/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.deployment;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.jms.JMSDestinationDefinition;
import javax.jms.JMSDestinationDefinitions;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.messaging.deployment.DirectJMSDestinationInjectionSource;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class MessagingJMSDefinitionAnnotationParser
implements DeploymentUnitProcessor {
    private static final DotName JMS_DESTINATION_DEFINITION = DotName.createSimple((String)JMSDestinationDefinition.class.getName());
    private static final DotName JMS_DESTINATION_DEFINITIONS = DotName.createSimple((String)JMSDestinationDefinitions.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        AnnotationTarget target;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        for (AnnotationInstance annotation : index.getAnnotations(JMS_DESTINATION_DEFINITIONS)) {
            target = annotation.target();
            if (!(target instanceof ClassInfo)) {
                throw EeMessages.MESSAGES.classOnlyAnnotation(JMS_DESTINATION_DEFINITIONS.toString(), target);
            }
            List<AnnotationInstance> destinationDefinitions = MessagingJMSDefinitionAnnotationParser.getNestedDefinitionAnnotations(annotation);
            for (AnnotationInstance definition : destinationDefinitions) {
                this.processJMSDestinationDefinition(eeModuleDescription, definition, (ClassInfo)target, applicationClasses);
            }
        }
        for (AnnotationInstance definition : index.getAnnotations(JMS_DESTINATION_DEFINITION)) {
            target = definition.target();
            if (!(target instanceof ClassInfo)) {
                throw EeMessages.MESSAGES.classOnlyAnnotation(JMS_DESTINATION_DEFINITION.toString(), target);
            }
            this.processJMSDestinationDefinition(eeModuleDescription, definition, (ClassInfo)target, applicationClasses);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void processJMSDestinationDefinition(EEModuleDescription eeModuleDescription, AnnotationInstance destinationDefinition, ClassInfo target, EEApplicationClasses applicationClasses) {
        AnnotationValue nameValue = destinationDefinition.value("name");
        if (nameValue == null || nameValue.asString().isEmpty()) {
            throw EeMessages.MESSAGES.annotationAttributeMissing(JMS_DESTINATION_DEFINITION.toString(), "name");
        }
        AnnotationValue interfaceNameValue = destinationDefinition.value("interfaceName");
        if (interfaceNameValue == null || interfaceNameValue.asString().isEmpty()) {
            throw EeMessages.MESSAGES.annotationAttributeMissing(JMS_DESTINATION_DEFINITION.toString(), "interfaceName");
        }
        DirectJMSDestinationInjectionSource source = new DirectJMSDestinationInjectionSource(nameValue.asString(), interfaceNameValue.asString());
        source.setDestinationName(MessagingJMSDefinitionAnnotationParser.asString(destinationDefinition, "destinationName"));
        for (String fullProp : MessagingJMSDefinitionAnnotationParser.asArray(destinationDefinition, "properties")) {
            String[] prop = fullProp.split("=", 2);
            source.addProperty(prop[0], prop[1]);
        }
        BindingConfiguration config = new BindingConfiguration(nameValue.asString(), (InjectionSource)source);
        eeModuleDescription.getBindingConfigurations().add(config);
    }

    private static List<AnnotationInstance> getNestedDefinitionAnnotations(AnnotationInstance definitions) {
        if (definitions == null) {
            return Collections.emptyList();
        }
        AnnotationInstance[] nested = definitions.value().asNestedArray();
        return Arrays.asList(nested);
    }

    private static String asString(AnnotationInstance annotation, String property) {
        return MessagingJMSDefinitionAnnotationParser.asString(annotation, property, "");
    }

    private static String asString(AnnotationInstance annotation, String property, String defaultValue) {
        AnnotationValue value = annotation.value(property);
        return value == null ? defaultValue : (value.asString().isEmpty() ? defaultValue : value.asString());
    }

    private static String[] asArray(AnnotationInstance annotation, String property) {
        AnnotationValue value = annotation.value(property);
        return value == null ? new String[]{} : value.asStringArray();
    }
}

