/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.deployment;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.messaging.BinderServiceUtil;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class MessagingJndiBindingProcessor
implements DeploymentUnitProcessor {
    public static final String DEFAULT_JMS_CONNECTION_FACTORY = "DefaultJMSConnectionFactory";
    public static final String JBOSS_DEFAULT_JMS_CONNECTION_FACTORY_LOOKUP = "java:jboss/DefaultJMSConnectionFactory";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription == null) {
            return;
        }
        if (phaseContext.getServiceRegistry().getService(ContextNames.bindInfoFor((String)JBOSS_DEFAULT_JMS_CONNECTION_FACTORY_LOOKUP).getBinderServiceName()) == null) {
            return;
        }
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            ServiceName moduleContextServiceName = ContextNames.contextServiceNameOfModule((String)moduleDescription.getApplicationName(), (String)moduleDescription.getModuleName());
            this.bindAliasService(deploymentUnit, serviceTarget, moduleContextServiceName, JBOSS_DEFAULT_JMS_CONNECTION_FACTORY_LOOKUP);
        }
        for (ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            if (component.getNamingMode() != ComponentNamingMode.CREATE) continue;
            ServiceName compContextServiceName = ContextNames.contextServiceNameOfComponent((String)moduleDescription.getApplicationName(), (String)moduleDescription.getModuleName(), (String)component.getComponentName());
            this.bindAliasService(deploymentUnit, serviceTarget, compContextServiceName, JBOSS_DEFAULT_JMS_CONNECTION_FACTORY_LOOKUP);
        }
    }

    private void bindAliasService(DeploymentUnit deploymentUnit, ServiceTarget serviceTarget, ServiceName contextServiceName, String connectionFactoryLookup) {
        ServiceName defaultJMSConnectionFactoryServiceName = contextServiceName.append(new String[]{DEFAULT_JMS_CONNECTION_FACTORY});
        BinderServiceUtil.installAliasBinderService(serviceTarget, contextServiceName, connectionFactoryLookup, defaultJMSConnectionFactoryServiceName, DEFAULT_JMS_CONNECTION_FACTORY);
        deploymentUnit.addToAttachmentList(org.jboss.as.server.deployment.Attachments.JNDI_DEPENDENCIES, (Object)defaultJMSConnectionFactoryServiceName);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

