/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.Channel;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionProvider;
import org.jboss.remoting3.remote.RemoteLogger;
import org.jboss.remoting3.remote.ServerConnectionOpenListener;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.remoting3.spi.ExternalConnectionProvider;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.FailedIoFuture;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.channels.AssembledConnectedSslStreamChannel;
import org.xnio.channels.AssembledConnectedStreamChannel;
import org.xnio.channels.ConnectedChannel;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.ConnectedSslStreamChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.FramedMessageChannel;
import org.xnio.channels.SslChannel;
import org.xnio.channels.SslConnection;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.http.HandshakeChecker;
import org.xnio.http.HttpUpgrade;
import org.xnio.ssl.XnioSsl;

final class HttpUpgradeConnectionProvider
extends RemoteConnectionProvider {
    public static final String MAGIC_NUMBER = "CF70DEB8-70F9-4FBA-8B4F-DFC3E723B4CD";
    public static final String SEC_JBOSS_REMOTING_KEY = "Sec-JbossRemoting-Key";
    public static final String SEC_JBOSS_REMOTING_ACCEPT = "sec-jbossremoting-accept";
    public static final String UPGRADE = "Upgrade";
    private final ProviderInterface providerInterface = new ProviderInterface();

    HttpUpgradeConnectionProvider(OptionMap optionMap, ConnectionProviderContext connectionProviderContext) throws IOException {
        super(optionMap, connectionProviderContext);
    }

    @Override
    protected IoFuture<ConnectedStreamChannel> createConnection(SocketAddress bindAddress, SocketAddress dst, OptionMap connectOptions, final ChannelListener<ConnectedStreamChannel> openListener) {
        URI uri;
        InetSocketAddress destination = (InetSocketAddress)dst;
        try {
            uri = new URI("http", "", destination.getHostName(), destination.getPort(), "/", "", "");
        }
        catch (URISyntaxException e) {
            return new FailedIoFuture(new IOException(e));
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(UPGRADE, "jboss-remoting");
        String secKey = this.createSecKey();
        headers.put(SEC_JBOSS_REMOTING_KEY, secKey);
        final FutureResult future = new FutureResult();
        HttpUpgrade.performUpgrade((XnioWorker)this.getXnioWorker(), (InetSocketAddress)((InetSocketAddress)bindAddress), (URI)uri, headers, (ChannelListener)new ChannelListener<StreamConnection>(){

            public void handleEvent(StreamConnection channel) {
                AssembledConnectedStreamChannel newChannel = new AssembledConnectedStreamChannel((ConnectedChannel)channel, (StreamSourceChannel)channel.getSourceChannel(), (StreamSinkChannel)channel.getSinkChannel());
                future.setResult((Object)newChannel);
                ChannelListeners.invokeChannelListener((Channel)newChannel, (ChannelListener)openListener);
            }
        }, null, (OptionMap)connectOptions, (HandshakeChecker)new RemotingHandshakeChecker(secKey)).addNotifier((IoFuture.Notifier)new IoFuture.Notifier<StreamConnection, Object>(){

            public void notify(IoFuture<? extends StreamConnection> ioFuture, Object attachment) {
                if (ioFuture.getStatus() == IoFuture.Status.FAILED) {
                    future.setException(ioFuture.getException());
                }
            }
        }, null);
        return future.getIoFuture();
    }

    @Override
    protected IoFuture<ConnectedSslStreamChannel> createSslConnection(SocketAddress bindAddress, InetSocketAddress destination, OptionMap connectOptions, XnioSsl xnioSsl, final ChannelListener<ConnectedStreamChannel> openListener) {
        URI uri;
        try {
            uri = new URI("https", "", destination.getHostName(), destination.getPort(), "/", "", "");
        }
        catch (URISyntaxException e) {
            return new FailedIoFuture(new IOException(e));
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(UPGRADE, "jboss-remoting");
        String secKey = this.createSecKey();
        headers.put(SEC_JBOSS_REMOTING_KEY, secKey);
        final FutureResult future = new FutureResult();
        HttpUpgrade.performUpgrade((XnioWorker)this.getXnioWorker(), (XnioSsl)xnioSsl, (InetSocketAddress)((InetSocketAddress)bindAddress), (URI)uri, headers, (ChannelListener)new ChannelListener<SslConnection>(){

            public void handleEvent(SslConnection channel) {
                AssembledConnectedSslStreamChannel newChannel = new AssembledConnectedSslStreamChannel((SslChannel)channel, (StreamSourceChannel)channel.getSourceChannel(), (StreamSinkChannel)channel.getSinkChannel());
                future.setResult((Object)newChannel);
                ChannelListeners.invokeChannelListener((Channel)newChannel, (ChannelListener)openListener);
            }
        }, null, (OptionMap)connectOptions, (HandshakeChecker)new RemotingHandshakeChecker(secKey)).addNotifier((IoFuture.Notifier)new IoFuture.Notifier<SslConnection, Object>(){

            public void notify(IoFuture<? extends SslConnection> ioFuture, Object attachment) {
                if (ioFuture.getStatus() == IoFuture.Status.FAILED) {
                    future.setException(ioFuture.getException());
                }
            }
        }, null);
        return future.getIoFuture();
    }

    @Override
    public ProviderInterface getProviderInterface() {
        return this.providerInterface;
    }

    protected String createSecKey() {
        SecureRandom random = new SecureRandom();
        byte[] data = new byte[16];
        for (int i = 0; i < 4; ++i) {
            int val = random.nextInt();
            data[i * 4] = (byte)val;
            data[i * 4 + 1] = (byte)(val >> 8 & 0xFF);
            data[i * 4 + 2] = (byte)(val >> 16 & 0xFF);
            data[i * 4 + 3] = (byte)(val >> 24 & 0xFF);
        }
        return FlexBase64.encodeString(data, false);
    }

    protected String createExpectedResponse(String secKey) throws IOException {
        try {
            String concat = secKey + MAGIC_NUMBER;
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            digest.update(concat.getBytes("UTF-8"));
            byte[] bytes = digest.digest();
            return FlexBase64.encodeString(bytes, false);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    private static class FlexBase64 {
        private static final byte[] ENCODING_TABLE;
        private static final byte[] DECODING_TABLE;
        private static final Constructor<String> STRING_CONSTRUCTOR;

        private FlexBase64() {
        }

        public static String encodeString(byte[] source, boolean wrap) {
            return FlexBase64.encodeString(source, 0, source.length, wrap);
        }

        private static String encodeString(byte[] source, int pos, int limit, boolean wrap) {
            int olimit;
            int remainder = (olimit = limit - pos) % 3;
            olimit = (olimit + (remainder == 0 ? 0 : 3 - remainder)) / 3 * 4;
            char[] target = new char[olimit += wrap ? olimit / 76 * 2 + 2 : 0];
            int opos = 0;
            int last = 0;
            int count = 0;
            int state = 0;
            byte[] ENCODING_TABLE = FlexBase64.ENCODING_TABLE;
            while (limit > pos) {
                int b = source[pos++] & 0xFF;
                target[opos++] = (char)ENCODING_TABLE[b >>> 2];
                last = (b & 3) << 4;
                if (pos >= limit) {
                    state = 1;
                    break;
                }
                b = source[pos++] & 0xFF;
                target[opos++] = (char)ENCODING_TABLE[last | b >>> 4];
                last = (b & 0xF) << 2;
                if (pos >= limit) {
                    state = 2;
                    break;
                }
                b = source[pos++] & 0xFF;
                target[opos++] = (char)ENCODING_TABLE[last | b >>> 6];
                target[opos++] = (char)ENCODING_TABLE[b & 0x3F];
                if (!wrap || (count += 4) < 76) continue;
                count = 0;
                target[opos++] = 13;
                target[opos++] = 10;
            }
            FlexBase64.complete(target, opos, state, last, wrap);
            try {
                if (STRING_CONSTRUCTOR != null) {
                    return STRING_CONSTRUCTOR.newInstance(target, Boolean.TRUE);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return new String(target);
        }

        private static int complete(char[] target, int pos, int state, int last, boolean wrap) {
            if (state > 0) {
                target[pos++] = (char)ENCODING_TABLE[last];
                for (int i = state; i < 3; ++i) {
                    target[pos++] = 61;
                }
            }
            if (wrap) {
                target[pos++] = 13;
                target[pos++] = 10;
            }
            return pos;
        }

        static {
            DECODING_TABLE = new byte[80];
            try {
                ENCODING_TABLE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes("ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException();
            }
            for (int i = 0; i < ENCODING_TABLE.length; ++i) {
                int v = (ENCODING_TABLE[i] & 0xFF) - 43;
                FlexBase64.DECODING_TABLE[v] = (byte)(i + 1);
            }
            Constructor c = null;
            try {
                PrivilegedExceptionAction<Constructor<String>> runnable = new PrivilegedExceptionAction<Constructor<String>>(){

                    @Override
                    public Constructor<String> run() throws Exception {
                        Constructor<String> c = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
                        c.setAccessible(true);
                        return c;
                    }
                };
                c = System.getSecurityManager() != null ? AccessController.doPrivileged(runnable) : (Constructor)runnable.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            STRING_CONSTRUCTOR = c;
        }
    }

    private final class ConnectionAdaptorImpl
    implements ExternalConnectionProvider.ConnectionAdaptor {
        private final OptionMap optionMap;
        private final ServerAuthenticationProvider authenticationProvider;
        private final AccessControlContext accessControlContext;

        private ConnectionAdaptorImpl(OptionMap optionMap, ServerAuthenticationProvider authenticationProvider, AccessControlContext accessControlContext) {
            this.optionMap = optionMap;
            this.authenticationProvider = authenticationProvider;
            this.accessControlContext = accessControlContext;
        }

        @Override
        public void adapt(ConnectedStreamChannel channel) {
            try {
                channel.setOption(Options.TCP_NODELAY, (Object)Boolean.TRUE);
            }
            catch (IOException e) {
                // empty catch block
            }
            FramedMessageChannel messageChannel = new FramedMessageChannel(channel, HttpUpgradeConnectionProvider.this.getFramingBufferPool().allocate(), HttpUpgradeConnectionProvider.this.getFramingBufferPool().allocate());
            RemoteConnection connection = new RemoteConnection(HttpUpgradeConnectionProvider.this.getMessageBufferPool(), channel, (ConnectedMessageChannel)messageChannel, this.optionMap, HttpUpgradeConnectionProvider.this);
            ServerConnectionOpenListener openListener = new ServerConnectionOpenListener(connection, HttpUpgradeConnectionProvider.this.getConnectionProviderContext(), this.authenticationProvider, this.optionMap, this.accessControlContext);
            messageChannel.getWriteSetter().set(connection.getWriteListener());
            RemoteLogger.log.tracef("Accepted connection from %s to %s", channel.getPeerAddress(), channel.getLocalAddress());
            openListener.handleEvent((ConnectedMessageChannel)messageChannel);
        }
    }

    final class ProviderInterface
    implements ExternalConnectionProvider {
        ProviderInterface() {
        }

        @Override
        public ExternalConnectionProvider.ConnectionAdaptor createConnectionAdaptor(OptionMap optionMap, ServerAuthenticationProvider authenticationProvider) throws IOException {
            AccessControlContext accessControlContext = AccessController.getContext();
            return new ConnectionAdaptorImpl(optionMap, authenticationProvider, accessControlContext);
        }
    }

    private class RemotingHandshakeChecker
    implements HandshakeChecker {
        private final String key;

        private RemotingHandshakeChecker(String key) {
            this.key = key;
        }

        public void checkHandshake(Map<String, String> headers) throws IOException {
            if (!headers.containsKey(HttpUpgradeConnectionProvider.SEC_JBOSS_REMOTING_ACCEPT)) {
                throw new IOException("No sec-jbossremoting-accept header in response");
            }
            String expectedResponse = HttpUpgradeConnectionProvider.this.createExpectedResponse(this.key);
            String response = headers.get(HttpUpgradeConnectionProvider.SEC_JBOSS_REMOTING_ACCEPT);
            if (!response.equals(expectedResponse)) {
                throw new IOException("sec-jbossremoting-accept value of " + response + " did not match expected " + expectedResponse);
            }
        }
    }
}

