/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.compensations.impl;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class BeanManagerUtil {
    public static BeanManager getBeanManager() {
        try {
            return (BeanManager)InitialContext.doLookup("java:comp/BeanManager");
        }
        catch (NamingException e) {
            try {
                return (BeanManager)InitialContext.doLookup("java:comp/env/BeanManager");
            }
            catch (NamingException e2) {
                throw new RuntimeException("BeanManager not available in JNDI");
            }
        }
    }

    public static <T> T createBeanInstance(Class<T> clazz, BeanManager bm) {
        Iterator iter = bm.getBeans(clazz, new Annotation[0]).iterator();
        if (!iter.hasNext()) {
            throw new IllegalStateException("CDI BeanManager cannot find an instance of requested type " + clazz.getName());
        }
        Bean bean = (Bean)iter.next();
        CreationalContext ctx = bm.createCreationalContext((Contextual)bean);
        return (T)bm.getReference(bean, clazz, ctx);
    }
}

