/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.compensations.impl;

import com.arjuna.mw.wst.TxContext;
import com.arjuna.mw.wst11.BusinessActivityManager;
import com.arjuna.mw.wst11.BusinessActivityManagerFactory;
import com.arjuna.mw.wst11.UserBusinessActivity;
import com.arjuna.mw.wst11.UserBusinessActivityFactory;
import com.arjuna.wst.TransactionRolledBackException;
import java.util.HashMap;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.narayana.compensations.api.Compensatable;
import org.jboss.narayana.compensations.api.TransactionCompensatedException;
import org.jboss.narayana.compensations.impl.CompensationManagerImpl;
import org.jboss.narayana.compensations.impl.CompensationManagerState;
import org.jboss.narayana.txframework.impl.TXDataMapImpl;

@Compensatable
@Interceptor
@Priority(value=197)
public class CompensationInterceptor {
    @AroundInvoke
    public Object intercept(InvocationContext ic) throws Exception {
        Object result;
        UserBusinessActivity uba = UserBusinessActivityFactory.userBusinessActivity();
        BusinessActivityManager bam = BusinessActivityManagerFactory.businessActivityManager();
        TxContext currentTX = bam.currentTransaction();
        boolean begun = false;
        if (currentTX == null) {
            uba.begin();
            begun = true;
            CompensationManagerImpl.resume(new CompensationManagerState());
            TXDataMapImpl.resume(new HashMap());
        }
        try {
            result = ic.proceed();
        }
        catch (RuntimeException e) {
            if (begun) {
                uba.cancel();
            }
            throw e;
        }
        if (begun) {
            if (!CompensationManagerImpl.isCompensateOnly()) {
                try {
                    uba.close();
                }
                catch (TransactionRolledBackException e) {
                    throw new TransactionCompensatedException("Failed to close transaction", e);
                }
            } else {
                uba.cancel();
                throw new TransactionCompensatedException("Transaction was marked as 'compensate only'");
            }
            CompensationManagerImpl.suspend();
            TXDataMapImpl.suspend();
        }
        return result;
    }
}

