/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.compensations.impl;

import com.arjuna.wst.BusinessAgreementWithParticipantCompletionParticipant;
import com.arjuna.wst.FaultedException;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.WrongStateException;
import com.arjuna.wst11.ConfirmCompletedParticipant;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.narayana.compensations.api.CompensationHandler;
import org.jboss.narayana.compensations.api.ConfirmationHandler;
import org.jboss.narayana.compensations.api.TransactionLoggedHandler;
import org.jboss.narayana.compensations.impl.BeanManagerUtil;
import org.jboss.narayana.txframework.impl.TXDataMapImpl;

public class Participant
implements BusinessAgreementWithParticipantCompletionParticipant,
ConfirmCompletedParticipant {
    private Class<? extends CompensationHandler> compensationHandler;
    private Class<? extends ConfirmationHandler> confirmationHandler;
    private Class<? extends TransactionLoggedHandler> transactionLoggedHandler;
    private BeanManager beanManager;
    private Map txDataMapState;

    public Participant(Class<? extends CompensationHandler> compensationHandlerClass, Class<? extends ConfirmationHandler> confirmationHandlerClass, Class<? extends TransactionLoggedHandler> transactionLoggedHandlerClass) {
        this.compensationHandler = compensationHandlerClass;
        this.confirmationHandler = confirmationHandlerClass;
        this.transactionLoggedHandler = transactionLoggedHandlerClass;
        this.beanManager = BeanManagerUtil.getBeanManager();
        this.txDataMapState = TXDataMapImpl.getState();
    }

    private <T> T instantiate(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        return BeanManagerUtil.createBeanInstance(clazz, this.beanManager);
    }

    public void confirmCompleted(boolean confirmed) {
        if (this.transactionLoggedHandler != null) {
            TXDataMapImpl.resume(this.txDataMapState);
            TransactionLoggedHandler handler = this.instantiate(this.transactionLoggedHandler);
            handler.transactionLogged(confirmed);
            TXDataMapImpl.suspend();
        }
    }

    public void close() throws WrongStateException, SystemException {
        if (this.confirmationHandler != null) {
            TXDataMapImpl.resume(this.txDataMapState);
            ConfirmationHandler handler = this.instantiate(this.confirmationHandler);
            handler.confirm();
            TXDataMapImpl.suspend();
        }
    }

    public void cancel() throws FaultedException, WrongStateException, SystemException {
    }

    public void compensate() throws FaultedException, WrongStateException, SystemException {
        try {
            if (this.compensationHandler != null) {
                TXDataMapImpl.resume(this.txDataMapState);
                CompensationHandler handler = this.instantiate(this.compensationHandler);
                handler.compensate();
                TXDataMapImpl.suspend();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String status() throws SystemException {
        return null;
    }

    public void unknown() throws SystemException {
    }

    public void error() throws SystemException {
    }
}

