/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.compensations.impl;

import com.arjuna.mw.wst11.BusinessActivityManager;
import com.arjuna.wst.BusinessAgreementWithParticipantCompletionParticipant;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.UnknownTransactionException;
import com.arjuna.wst.WrongStateException;
import com.arjuna.wst11.BAParticipantManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.UUID;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.narayana.compensations.api.NoTransactionException;
import org.jboss.narayana.compensations.api.TransactionLoggedHandler;
import org.jboss.narayana.compensations.api.TxLogged;
import org.jboss.narayana.compensations.impl.Participant;
import org.jboss.narayana.compensations.impl.ParticipantInterceptor;

@TxLogged
@Interceptor
@Priority(value=198)
public class TxLoggedInterceptor
extends ParticipantInterceptor {
    @Override
    @AroundInvoke
    public Object intercept(InvocationContext ic) throws Exception {
        return super.intercept(ic);
    }

    @Override
    protected BAParticipantManager enlistParticipant(BusinessActivityManager bam, Method method) throws WrongStateException, UnknownTransactionException, SystemException {
        if (bam.currentTransaction() == null) {
            throw new NoTransactionException("Methods annotated with '" + TxLogged.class.getName() + "' must be invoked in the context of a compensation based transaction");
        }
        Class<? extends TransactionLoggedHandler> transactionLogHandler = this.getTransactionLoggedHandler(method);
        Participant compensationParticipant = new Participant(null, null, transactionLogHandler);
        return bam.enlistForBusinessAgreementWithParticipantCompletion((BusinessAgreementWithParticipantCompletionParticipant)compensationParticipant, String.valueOf(UUID.randomUUID()));
    }

    private Class<? extends TransactionLoggedHandler> getTransactionLoggedHandler(Method method) {
        Annotation[] annotations;
        for (Annotation a : annotations = method.getAnnotations()) {
            if (!(a instanceof TxLogged)) continue;
            return ((TxLogged)a).value();
        }
        return null;
    }
}

