/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal;

import java.util.Map;
import java.util.Properties;
import org.hibernate.MappingException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.envers.RevisionListener;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.internal.util.config.ConfigurationHelper;

public class GlobalConfiguration {
    private final boolean generateRevisionsForCollections;
    private final boolean doNotAuditOptimisticLockingField;
    private final boolean storeDataAtDelete;
    private final String defaultSchemaName;
    private final String defaultCatalogName;
    private boolean trackEntitiesChangedInRevision;
    private final Class<? extends RevisionListener> revisionListenerClass;
    private boolean globalWithModifiedFlag;
    private boolean hasGlobalSettingForWithModifiedFlag;
    private String modifiedFlagSuffix;
    private final boolean useRevisionEntityWithNativeId;
    private final String correlatedSubqueryOperator;

    public GlobalConfiguration(Properties properties, ClassLoaderService classLoaderService) {
        this.generateRevisionsForCollections = ConfigurationHelper.getBoolean((String)"org.hibernate.envers.revision_on_collection_change", (Map)properties, (boolean)true);
        this.doNotAuditOptimisticLockingField = ConfigurationHelper.getBoolean((String)"org.hibernate.envers.do_not_audit_optimistic_locking_field", (Map)properties, (boolean)true);
        this.storeDataAtDelete = ConfigurationHelper.getBoolean((String)"org.hibernate.envers.store_data_at_delete", (Map)properties, (boolean)false);
        this.defaultSchemaName = properties.getProperty("org.hibernate.envers.default_schema", null);
        this.defaultCatalogName = properties.getProperty("org.hibernate.envers.default_catalog", null);
        this.correlatedSubqueryOperator = HSQLDialect.class.getName().equals(properties.get("hibernate.dialect")) ? "in" : "=";
        this.trackEntitiesChangedInRevision = ConfigurationHelper.getBoolean((String)"org.hibernate.envers.track_entities_changed_in_revision", (Map)properties, (boolean)false);
        this.useRevisionEntityWithNativeId = ConfigurationHelper.getBoolean((String)"org.hibernate.envers.use_revision_entity_with_native_id", (Map)properties, (boolean)true);
        this.hasGlobalSettingForWithModifiedFlag = properties.get("org.hibernate.envers.global_with_modified_flag") != null;
        this.globalWithModifiedFlag = ConfigurationHelper.getBoolean((String)"org.hibernate.envers.global_with_modified_flag", (Map)properties, (boolean)false);
        this.modifiedFlagSuffix = ConfigurationHelper.getString((String)"org.hibernate.envers.modified_flag_suffix", (Map)properties, (String)"_MOD");
        String revisionListenerClassName = properties.getProperty("org.hibernate.envers.revision_listener", null);
        if (revisionListenerClassName != null) {
            try {
                this.revisionListenerClass = ReflectionTools.loadClass(revisionListenerClassName, classLoaderService);
            }
            catch (ClassLoadingException e) {
                throw new MappingException("Revision listener class not found: " + revisionListenerClassName + ".", (Throwable)e);
            }
        } else {
            this.revisionListenerClass = null;
        }
    }

    public boolean isGenerateRevisionsForCollections() {
        return this.generateRevisionsForCollections;
    }

    public boolean isDoNotAuditOptimisticLockingField() {
        return this.doNotAuditOptimisticLockingField;
    }

    public String getCorrelatedSubqueryOperator() {
        return this.correlatedSubqueryOperator;
    }

    public boolean isStoreDataAtDelete() {
        return this.storeDataAtDelete;
    }

    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    public String getDefaultCatalogName() {
        return this.defaultCatalogName;
    }

    public boolean isTrackEntitiesChangedInRevision() {
        return this.trackEntitiesChangedInRevision;
    }

    public void setTrackEntitiesChangedInRevision(boolean trackEntitiesChangedInRevision) {
        this.trackEntitiesChangedInRevision = trackEntitiesChangedInRevision;
    }

    public Class<? extends RevisionListener> getRevisionListenerClass() {
        return this.revisionListenerClass;
    }

    public boolean hasSettingForUsingModifiedFlag() {
        return this.hasGlobalSettingForWithModifiedFlag;
    }

    public boolean isGlobalWithModifiedFlag() {
        return this.globalWithModifiedFlag;
    }

    public String getModifiedFlagSuffix() {
        return this.modifiedFlagSuffix;
    }

    public boolean isUseRevisionEntityWithNativeId() {
        return this.useRevisionEntityWithNativeId;
    }
}

