/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.configuration.Builder;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreAsBinaryConfiguration;

public class StoreAsBinaryConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<StoreAsBinaryConfiguration> {
    private boolean enabled = false;
    private boolean storeKeysAsBinary = true;
    private boolean storeValuesAsBinary = true;
    private boolean defensive = false;

    StoreAsBinaryConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public StoreAsBinaryConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public StoreAsBinaryConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public StoreAsBinaryConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public StoreAsBinaryConfigurationBuilder storeKeysAsBinary(boolean storeKeysAsBinary) {
        this.storeKeysAsBinary = storeKeysAsBinary;
        return this;
    }

    public StoreAsBinaryConfigurationBuilder storeValuesAsBinary(boolean storeValuesAsBinary) {
        this.storeValuesAsBinary = storeValuesAsBinary;
        return this;
    }

    public StoreAsBinaryConfigurationBuilder defensive(boolean defensive) {
        this.defensive = defensive;
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public StoreAsBinaryConfiguration create() {
        return new StoreAsBinaryConfiguration(this.enabled, this.storeKeysAsBinary, this.storeValuesAsBinary, this.defensive);
    }

    public StoreAsBinaryConfigurationBuilder read(StoreAsBinaryConfiguration template) {
        this.enabled = template.enabled();
        this.storeKeysAsBinary = template.storeKeysAsBinary();
        this.storeValuesAsBinary = template.storeValuesAsBinary();
        this.defensive = template.defensive();
        return this;
    }

    public String toString() {
        return "StoreAsBinaryConfigurationBuilder{enabled=" + this.enabled + ", storeKeysAsBinary=" + this.storeKeysAsBinary + ", storeValuesAsBinary=" + this.storeValuesAsBinary + '}';
    }
}

