/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.Version;
import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.SerializationConfiguration;
import org.infinispan.marshall.AdvancedExternalizer;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.VersionAwareMarshaller;
import org.jboss.marshalling.ClassResolver;

public class SerializationConfigurationBuilder
extends AbstractGlobalConfigurationBuilder<SerializationConfiguration> {
    private Marshaller marshaller = new VersionAwareMarshaller();
    private short marshallVersion = Short.valueOf("5.3".replace(".", ""));
    private Map<Integer, AdvancedExternalizer<?>> advancedExternalizers = new HashMap();
    private ClassResolver classResolver;

    SerializationConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
    }

    public SerializationConfigurationBuilder marshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
        return this;
    }

    public SerializationConfigurationBuilder version(short marshallVersion) {
        this.marshallVersion = marshallVersion;
        return this;
    }

    public SerializationConfigurationBuilder version(String marshallVersion) {
        this.marshallVersion = Version.getVersionShort(marshallVersion);
        return this;
    }

    public <T> SerializationConfigurationBuilder addAdvancedExternalizer(int id, AdvancedExternalizer<T> advancedExternalizer) {
        AdvancedExternalizer<?> ext = this.advancedExternalizers.get(id);
        if (ext != null) {
            throw new ConfigurationException(String.format("Duplicate externalizer id found! Externalizer id=%d for %s is shared by another externalizer (%s)", id, advancedExternalizer.getClass().getName(), ext.getClass().getName()));
        }
        this.advancedExternalizers.put(id, advancedExternalizer);
        return this;
    }

    public <T> SerializationConfigurationBuilder addAdvancedExternalizer(AdvancedExternalizer<T> advancedExternalizer) {
        Integer id = advancedExternalizer.getId();
        if (id == null) {
            throw new ConfigurationException(String.format("No advanced externalizer identifier set for externalizer %s", advancedExternalizer.getClass().getName()));
        }
        this.addAdvancedExternalizer(id, advancedExternalizer);
        return this;
    }

    public <T> SerializationConfigurationBuilder addAdvancedExternalizer(AdvancedExternalizer<T> ... advancedExternalizers) {
        for (AdvancedExternalizer<T> advancedExternalizer : advancedExternalizers) {
            this.addAdvancedExternalizer(advancedExternalizer);
        }
        return this;
    }

    public SerializationConfigurationBuilder classResolver(ClassResolver classResolver) {
        this.classResolver = classResolver;
        return this;
    }

    @Override
    protected void validate() {
    }

    @Override
    SerializationConfiguration create() {
        return new SerializationConfiguration(this.marshaller, this.marshallVersion, this.advancedExternalizers, this.classResolver);
    }

    protected SerializationConfigurationBuilder read(SerializationConfiguration template) {
        this.advancedExternalizers = template.advancedExternalizers();
        this.marshaller = template.marshaller();
        this.marshallVersion = template.version();
        this.classResolver = template.classResolver();
        return this;
    }

    public String toString() {
        return "SerializationConfigurationBuilder{advancedExternalizers=" + this.advancedExternalizers + ", marshaller=" + this.marshaller + ", marshallVersion=" + this.marshallVersion + ", classResolver=" + this.classResolver + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializationConfigurationBuilder that = (SerializationConfigurationBuilder)o;
        if (this.marshallVersion != that.marshallVersion) {
            return false;
        }
        if (this.advancedExternalizers != null ? !((Object)this.advancedExternalizers).equals(that.advancedExternalizers) : that.advancedExternalizers != null) {
            return false;
        }
        if (this.marshaller != null ? !this.marshaller.equals(that.marshaller) : that.marshaller != null) {
            return false;
        }
        return !(this.classResolver != null ? !this.classResolver.equals(that.classResolver) : that.classResolver != null);
    }

    public int hashCode() {
        int result = this.marshaller != null ? this.marshaller.hashCode() : 0;
        result = 31 * result + this.marshallVersion;
        result = 31 * result + (this.advancedExternalizers != null ? ((Object)this.advancedExternalizers).hashCode() : 0);
        result = 31 * result + (this.classResolver != null ? this.classResolver.hashCode() : 0);
        return result;
    }
}

