/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.components;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.CacheException;
import org.infinispan.factories.components.ComponentMetadata;
import org.infinispan.factories.components.ModuleMetadataFileFinder;

public class ComponentMetadataRepo {
    final Map<String, ComponentMetadata> componentMetadataMap = new HashMap<String, ComponentMetadata>(128);
    final Map<String, String> factories = new HashMap<String, String>(16);
    private final ComponentMetadata dependencyFreeComponent = new ComponentMetadata();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void readMetadata(URL metadataFile) throws IOException, ClassNotFoundException {
        Map fact;
        Map comp;
        InputStream inputStream = metadataFile.openStream();
        try {
            BufferedInputStream bis = new BufferedInputStream(inputStream);
            try {
                ObjectInputStream ois = new ObjectInputStream(bis);
                try {
                    comp = (Map)ois.readObject();
                    fact = (Map)ois.readObject();
                }
                finally {
                    ois.close();
                }
            }
            finally {
                bis.close();
            }
        }
        finally {
            inputStream.close();
        }
        this.componentMetadataMap.putAll(comp);
        this.factories.putAll(fact);
    }

    public ComponentMetadata findComponentMetadata(Class<?> componentType) {
        ComponentMetadata md = null;
        while (md == null) {
            String componentName = componentType.getName();
            md = this.componentMetadataMap.get(componentName);
            if (md != null) continue;
            if (!componentType.equals(Object.class) && !componentType.isInterface()) {
                componentType = componentType.getSuperclass();
                continue;
            }
            md = this.dependencyFreeComponent;
        }
        return md;
    }

    public ComponentMetadata findComponentMetadata(String componentName) {
        return this.componentMetadataMap.get(componentName);
    }

    public String findFactoryForComponent(Class<?> componentType) {
        return this.factories.get(componentType.getName());
    }

    public void initialize(Iterable<ModuleMetadataFileFinder> moduleMetadataFiles, ClassLoader cl) {
        try {
            this.readMetadata(cl.getResource("infinispan-core-component-metadata.dat"));
        }
        catch (Exception e) {
            throw new CacheException("Unable to load component metadata!", e);
        }
        for (ModuleMetadataFileFinder finder : moduleMetadataFiles) {
            try {
                this.readMetadata(cl.getResource(finder.getMetadataFilename()));
            }
            catch (Exception e) {
                throw new CacheException("Unable to load component metadata in file " + finder.getMetadataFilename(), e);
            }
        }
    }

    public void injectFactoryForComponent(Class<?> componentType, Class<?> factoryType) {
        this.factories.put(componentType.getName(), factoryType.getName());
    }
}

