/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction;

import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ClusteredRepeatableReadEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.transaction.WriteSkewException;
import org.infinispan.transaction.xa.CacheTransaction;

public class WriteSkewHelper {
    public static void setVersionsSeenOnPrepareCommand(VersionedPrepareCommand command, TxInvocationContext context) {
        EntryVersionsMap vs = new EntryVersionsMap();
        for (WriteCommand wc : command.getModifications()) {
            for (Object k : wc.getAffectedKeys()) {
                CacheEntry entry = context.lookupEntry(k);
                if (entry == null) continue;
                vs.put(k, (IncrementableEntryVersion)entry.getMetadata().version());
            }
        }
        command.setVersionsSeen(vs);
    }

    public static void readVersionsFromResponse(Response r, CacheTransaction ct) {
        SuccessfulResponse sr;
        EntryVersionsMap uv;
        if (r != null && r.isSuccessful() && (uv = (EntryVersionsMap)(sr = (SuccessfulResponse)r).getResponseValue()) != null) {
            ct.setUpdatedEntryVersions(uv.merge(ct.getUpdatedEntryVersions()));
        }
    }

    public static EntryVersionsMap performWriteSkewCheckAndReturnNewVersions(VersionedPrepareCommand prepareCommand, DataContainer dataContainer, VersionGenerator versionGenerator, TxInvocationContext context, KeySpecificLogic ksl) {
        EntryVersionsMap uv = new EntryVersionsMap();
        for (WriteCommand c : prepareCommand.getModifications()) {
            for (Object k : c.getAffectedKeys()) {
                EntryVersion versionSeen;
                ClusteredRepeatableReadEntry entry;
                if (!ksl.performCheckOnKey(k) || (entry = (ClusteredRepeatableReadEntry)context.lookupEntry(k)) == null) continue;
                if (!context.isOriginLocal() && (versionSeen = (EntryVersion)prepareCommand.getVersionsSeen().get(k)) != null) {
                    entry.setVersion(versionSeen);
                }
                if (entry.performWriteSkewCheck(dataContainer, context, c.wasPreviousRead())) {
                    IncrementableEntryVersion newVersion = entry.isCreated() ? versionGenerator.generateNew() : versionGenerator.increment((IncrementableEntryVersion)entry.getMetadata().version());
                    uv.put(k, newVersion);
                    continue;
                }
                throw new WriteSkewException("Write skew detected on key " + k + " for transaction " + context.getTransaction());
            }
        }
        return uv;
    }

    public static EntryVersionsMap performTotalOrderWriteSkewCheckAndReturnNewVersions(VersionedPrepareCommand prepareCommand, DataContainer dataContainer, TxInvocationContext context, KeySpecificLogic ksl) {
        EntryVersionsMap uv = new EntryVersionsMap();
        for (WriteCommand c : prepareCommand.getModifications()) {
            for (Object k : c.getAffectedKeys()) {
                ClusteredRepeatableReadEntry entry;
                if (!ksl.performCheckOnKey(k) || (entry = (ClusteredRepeatableReadEntry)context.lookupEntry(k)) == null) continue;
                EntryVersion versionSeen = (EntryVersion)prepareCommand.getVersionsSeen().get(k);
                entry.setVersion(versionSeen);
                if (entry.performWriteSkewCheck(dataContainer, context, c.wasPreviousRead())) {
                    uv.put(k, null);
                    continue;
                }
                throw new WriteSkewException("Write skew detected on key " + k + " for transaction " + context.getTransaction());
            }
        }
        return uv;
    }

    public static interface KeySpecificLogic {
        public boolean performCheckOnKey(Object var1);
    }
}

