/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import javax.transaction.Transaction;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.cache.infinispan.impl.BaseRegion;
import org.hibernate.cache.infinispan.util.Caches;
import org.infinispan.AdvancedCache;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionalAccessDelegate {
    private static final Log log = LogFactory.getLog(TransactionalAccessDelegate.class);
    private static final boolean TRACE_ENABLED = log.isTraceEnabled();
    private final AdvancedCache cache;
    private final BaseRegion region;
    private final PutFromLoadValidator putValidator;
    private final AdvancedCache<Object, Object> writeCache;

    public TransactionalAccessDelegate(BaseRegion region, PutFromLoadValidator validator) {
        this.region = region;
        this.cache = region.getCache();
        this.putValidator = validator;
        this.writeCache = Caches.ignoreReturnValuesCache(this.cache);
    }

    public Object get(Object key, long txTimestamp) throws CacheException {
        if (!this.region.checkValid()) {
            return null;
        }
        Object val = this.cache.get(key);
        if (val == null) {
            this.putValidator.registerPendingPut(key);
        }
        return val;
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version) {
        return this.putFromLoad(key, value, txTimestamp, version, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        if (!this.region.checkValid()) {
            if (TRACE_ENABLED) {
                log.tracef("Region %s not valid", (Object)this.region.getName());
            }
            return false;
        }
        if (minimalPutOverride && this.cache.containsKey(key)) {
            return false;
        }
        if (!this.putValidator.acquirePutFromLoadLock(key)) {
            if (TRACE_ENABLED) {
                log.tracef("Put from load lock not acquired for key %s", key);
            }
            return false;
        }
        try {
            this.writeCache.putForExternalRead(key, value);
        }
        finally {
            this.putValidator.releasePutFromLoadLock(key);
        }
        return true;
    }

    public boolean insert(Object key, Object value, Object version) throws CacheException {
        if (!this.region.checkValid()) {
            return false;
        }
        this.writeCache.put(key, value);
        return true;
    }

    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        this.writeCache.put(key, value);
        return true;
    }

    public void remove(Object key) throws CacheException {
        if (!this.putValidator.invalidateKey(key)) {
            throw new CacheException("Failed to invalidate pending putFromLoad calls for key " + key + " from region " + this.region.getName());
        }
        this.writeCache.remove(key);
    }

    public void removeAll() throws CacheException {
        if (!this.putValidator.invalidateRegion()) {
            throw new CacheException("Failed to invalidate pending putFromLoad calls for region " + this.region.getName());
        }
        this.cache.clear();
    }

    public void evict(Object key) throws CacheException {
        if (!this.putValidator.invalidateKey(key)) {
            throw new CacheException("Failed to invalidate pending putFromLoad calls for key " + key + " from region " + this.region.getName());
        }
        this.writeCache.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll() throws CacheException {
        if (!this.putValidator.invalidateRegion()) {
            throw new CacheException("Failed to invalidate pending putFromLoad calls for region " + this.region.getName());
        }
        Transaction tx = this.region.suspend();
        try {
            this.region.invalidateRegion();
            Caches.broadcastEvictAll(this.cache);
        }
        finally {
            this.region.resume(tx);
        }
    }
}

