/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import java.io.UnsupportedEncodingException;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.conversation.dkalgo.AlgoFactory;
import org.apache.ws.security.conversation.dkalgo.DerivationAlgorithm;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignatureBase;
import org.apache.ws.security.message.token.DerivedKeyToken;
import org.apache.ws.security.message.token.KerberosSecurity;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class WSSecDerivedKeyBase
extends WSSecSignatureBase {
    protected Document document;
    protected byte[] ephemeralKey;
    protected DerivedKeyToken dkt = null;
    protected byte[] derivedKeyBytes = null;
    protected String dktId = null;
    protected String clientLabel = "WS-SecureConversation";
    protected String serviceLabel = "WS-SecureConversation";
    protected Element envelope = null;
    protected String tokenIdentifier = null;
    protected boolean tokenIdDirectId;
    protected Element strElem;
    private int wscVersion = 1;
    protected int derivedKeyLength = -1;
    private String customValueType;

    protected abstract int getDerivedKeyLength() throws WSSecurityException;

    public WSSecDerivedKeyBase() {
    }

    public WSSecDerivedKeyBase(WSSConfig config) {
        super(config);
    }

    public void setExternalKey(byte[] ephemeralKey, String tokenIdentifier) {
        this.ephemeralKey = ephemeralKey;
        this.tokenIdentifier = tokenIdentifier;
    }

    public void setExternalKey(byte[] ephemeralKey, Element strElem) {
        this.ephemeralKey = ephemeralKey;
        this.strElem = strElem;
    }

    public String getTokenIdentifier() {
        return this.tokenIdentifier;
    }

    public String getId() {
        return this.dktId;
    }

    public void setClientLabel(String clientLabel) {
        this.clientLabel = clientLabel;
    }

    public void setServiceLabel(String serviceLabel) {
        this.serviceLabel = serviceLabel;
    }

    public void prepare(Document doc) throws WSSecurityException, ConversationException {
        byte[] label;
        this.document = doc;
        int offset = 0;
        int length = this.getDerivedKeyLength();
        try {
            label = (this.clientLabel + this.serviceLabel).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WSSecurityException("UTF-8 encoding is not supported", e);
        }
        byte[] nonce = WSSecurityUtil.generateNonce(16);
        byte[] seed = new byte[label.length + nonce.length];
        System.arraycopy(label, 0, seed, 0, label.length);
        System.arraycopy(nonce, 0, seed, label.length, nonce.length);
        DerivationAlgorithm algo = AlgoFactory.getInstance("http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1");
        this.derivedKeyBytes = algo.createKey(this.ephemeralKey, seed, offset, length);
        this.dkt = new DerivedKeyToken(this.wscVersion, this.document);
        this.dktId = this.getWsConfig().getIdAllocator().createId("DK-", this.dkt);
        this.dkt.setOffset(offset);
        this.dkt.setLength(length);
        this.dkt.setNonce(Base64.encode(nonce));
        this.dkt.setID(this.dktId);
        if (this.strElem == null) {
            SecurityTokenReference secRef = new SecurityTokenReference(this.document);
            String strUri = this.getWsConfig().getIdAllocator().createSecureId("STR-", secRef);
            secRef.setID(strUri);
            switch (this.keyIdentifierType) {
                case 12: {
                    secRef.setKeyIdentifier(this.customValueType, this.tokenIdentifier);
                    if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(this.customValueType)) {
                        secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
                        break;
                    }
                    if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(this.customValueType)) {
                        secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
                        break;
                    }
                    if (!"http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey".equals(this.customValueType)) break;
                    secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                    break;
                }
                default: {
                    Reference ref = new Reference(this.document);
                    if (this.tokenIdDirectId) {
                        ref.setURI(this.tokenIdentifier);
                    } else {
                        ref.setURI("#" + this.tokenIdentifier);
                    }
                    if (this.customValueType != null && !"".equals(this.customValueType)) {
                        ref.setValueType(this.customValueType);
                    }
                    if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(this.customValueType)) {
                        secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
                        ref.setValueType(this.customValueType);
                    } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(this.customValueType)) {
                        secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
                    } else if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey".equals(this.customValueType)) {
                        secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                        ref.setValueType(this.customValueType);
                    } else if (KerberosSecurity.isKerberosToken(this.customValueType)) {
                        secRef.addTokenType(this.customValueType);
                        ref.setValueType(this.customValueType);
                    } else if ("http://schemas.xmlsoap.org/ws/2005/02/sc/sct".equals(this.customValueType) || "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct".equals(this.customValueType)) {
                        ref.setValueType(this.customValueType);
                    } else if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken".equals(this.customValueType)) {
                        secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                    }
                    secRef.setReference(ref);
                }
            }
            this.dkt.setSecurityTokenReference(secRef);
        } else {
            this.dkt.setSecurityTokenReference(this.strElem);
        }
    }

    public void prependDKElementToHeader(WSSecHeader secHeader) {
        WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), this.dkt.getElement());
    }

    public void appendDKElementToHeader(WSSecHeader secHeader) {
        Element secHeaderElement = secHeader.getSecurityHeader();
        secHeaderElement.appendChild(this.dkt.getElement());
    }

    public void setWscVersion(int wscVersion) {
        this.wscVersion = wscVersion;
    }

    public int getWscVersion() {
        return this.wscVersion;
    }

    public Element getdktElement() {
        return this.dkt.getElement();
    }

    public void setDerivedKeyLength(int keyLength) {
        this.derivedKeyLength = keyLength;
    }

    public void setCustomValueType(String customValueType) {
        this.customValueType = customValueType;
    }

    public void setTokenIdDirectId(boolean b) {
        this.tokenIdDirectId = b;
    }
}

