/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.subsystem;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.naming.subsystem.NamingBindingResourceDefinition;
import org.jboss.as.naming.subsystem.NamingExtension;
import org.jboss.as.naming.subsystem.NamingSubsystemNamespace;
import org.jboss.as.naming.subsystem.NamingSubsystemXMLAttribute;
import org.jboss.as.naming.subsystem.NamingSubsystemXMLElement;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class NamingSubsystem13Parser
implements XMLElementReader<List<ModelNode>> {
    public static final NamingSubsystem13Parser INSTANCE = new NamingSubsystem13Parser();

    private NamingSubsystem13Parser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{NamingExtension.SUBSYSTEM_PATH});
        ModelNode ejb3SubsystemAddOperation = Util.createAddOperation((PathAddress)address);
        operations.add(ejb3SubsystemAddOperation);
        EnumSet<NamingSubsystemXMLElement> encountered = EnumSet.noneOf(NamingSubsystemXMLElement.class);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (NamingSubsystemNamespace.forUri(reader.getNamespaceURI())) {
                case NAMING_1_3: {
                    NamingSubsystemXMLElement element = NamingSubsystemXMLElement.forName(reader.getLocalName());
                    if (!encountered.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (element) {
                        case BINDINGS: {
                            this.parseBindings(reader, operations, address);
                            continue block7;
                        }
                        case REMOTE_NAMING: {
                            this.parseRemoteNaming(reader, operations, address);
                            continue block7;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseRemoteNaming(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress parent) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(Util.createAddOperation((PathAddress)parent.append("service", "remote-naming")));
    }

    private void parseBindings(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress address) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (NamingSubsystemXMLElement.forName(reader.getLocalName())) {
                case SIMPLE: {
                    this.parseSimpleBinding(reader, operations, address);
                    continue block5;
                }
                case OBJECT_FACTORY: {
                    this.parseObjectFactoryBinding(reader, operations, address);
                    continue block5;
                }
                case LOOKUP: {
                    this.parseLookupBinding(reader, operations, address);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSimpleBinding(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress parentAddress) throws XMLStreamException {
        String name = null;
        ModelNode bindingAdd = Util.createAddOperation();
        bindingAdd.get("binding-type").set("simple");
        EnumSet<NamingSubsystemXMLAttribute> required = EnumSet.of(NamingSubsystemXMLAttribute.NAME, NamingSubsystemXMLAttribute.VALUE);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            NamingSubsystemXMLAttribute attribute = NamingSubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value.trim();
                    continue block5;
                }
                case VALUE: {
                    NamingBindingResourceDefinition.VALUE.parseAndSetParameter(value, bindingAdd, (XMLStreamReader)reader);
                    continue block5;
                }
                case TYPE: {
                    NamingBindingResourceDefinition.TYPE.parseAndSetParameter(value, bindingAdd, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        PathAddress address = parentAddress.append("binding", name);
        bindingAdd.get("address").set(address.toModelNode());
        operations.add(bindingAdd);
    }

    private void parseObjectFactoryBinding(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress parentAddress) throws XMLStreamException {
        int attCount = reader.getAttributeCount();
        String name = null;
        ModelNode bindingAdd = Util.createAddOperation();
        bindingAdd.get("binding-type").set("object-factory");
        EnumSet<NamingSubsystemXMLAttribute> required = EnumSet.of(NamingSubsystemXMLAttribute.NAME, NamingSubsystemXMLAttribute.MODULE, NamingSubsystemXMLAttribute.CLASS);
        block8: for (int i = 0; i < attCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            NamingSubsystemXMLAttribute attribute = NamingSubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value.trim();
                    continue block8;
                }
                case MODULE: {
                    NamingBindingResourceDefinition.MODULE.parseAndSetParameter(value, bindingAdd, (XMLStreamReader)reader);
                    continue block8;
                }
                case CLASS: {
                    NamingBindingResourceDefinition.CLASS.parseAndSetParameter(value, bindingAdd, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        bindingAdd.get("address").set(parentAddress.append("binding", name).toModelNode());
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (NamingSubsystemXMLElement.forName(reader.getLocalName())) {
                case ENVIRONMENT: {
                    this.parseObjectFactoryBindingEnvironment(reader, bindingAdd);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(bindingAdd);
    }

    private void parseObjectFactoryBindingEnvironment(XMLExtendedStreamReader reader, ModelNode bindingAdd) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (NamingSubsystemXMLElement.forName(reader.getLocalName())) {
                case ENVIRONMENT_PROPERTY: {
                    String[] array = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.NAME.getLocalName(), Attribute.VALUE.getLocalName()});
                    NamingBindingResourceDefinition.ENVIRONMENT.parseAndAddParameterElement(array[0], array[1], bindingAdd, reader);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseLookupBinding(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress parentAddress) throws XMLStreamException {
        int attCount = reader.getAttributeCount();
        String name = null;
        ModelNode bindingAdd = Util.createAddOperation();
        bindingAdd.get("binding-type").set("lookup");
        EnumSet<NamingSubsystemXMLAttribute> required = EnumSet.of(NamingSubsystemXMLAttribute.NAME, NamingSubsystemXMLAttribute.LOOKUP);
        block4: for (int i = 0; i < attCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            NamingSubsystemXMLAttribute attribute = NamingSubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value.trim();
                    continue block4;
                }
                case LOOKUP: {
                    NamingBindingResourceDefinition.LOOKUP.parseAndSetParameter(value, bindingAdd, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        bindingAdd.get("address").set(parentAddress.append("binding", name).toModelNode());
        operations.add(bindingAdd);
    }
}

