/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.StaleObjectStateException;
import org.hibernate.WrongClassException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.TwoPhaseLoad;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.loader.EntityAliases;
import org.hibernate.loader.internal.ResultSetProcessorHelper;
import org.hibernate.loader.plan.spi.CollectionFetch;
import org.hibernate.loader.plan.spi.CollectionReturn;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.plan.spi.LoadPlan;
import org.hibernate.loader.plan.spi.visit.LoadPlanVisitationStrategyAdapter;
import org.hibernate.loader.plan.spi.visit.LoadPlanVisitor;
import org.hibernate.loader.spi.AfterLoadAction;
import org.hibernate.loader.spi.LoadQueryAliasResolutionContext;
import org.hibernate.loader.spi.NamedParameterContext;
import org.hibernate.loader.spi.ResultSetProcessingContext;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.VersionType;
import org.jboss.logging.Logger;

public class ResultSetProcessingContextImpl
implements ResultSetProcessingContext {
    private static final Logger LOG = Logger.getLogger(ResultSetProcessingContextImpl.class);
    private final ResultSet resultSet;
    private final SessionImplementor session;
    private final LoadPlan loadPlan;
    private final boolean readOnly;
    private final QueryParameters queryParameters;
    private final NamedParameterContext namedParameterContext;
    private final LoadQueryAliasResolutionContext aliasResolutionContext;
    private final boolean hadSubselectFetches;
    private final EntityKey dictatedRootEntityKey;
    private List<HydratedEntityRegistration> currentRowHydratedEntityRegistrationList;
    private Map<EntityPersister, Set<EntityKey>> subselectLoadableEntityKeyMap;
    private List<HydratedEntityRegistration> hydratedEntityRegistrationList;
    private Map<EntityReference, ResultSetProcessingContext.IdentifierResolutionContext> identifierResolutionContextMap;

    public ResultSetProcessingContextImpl(ResultSet resultSet, SessionImplementor session, LoadPlan loadPlan, boolean readOnly, boolean useOptionalEntityKey, QueryParameters queryParameters, NamedParameterContext namedParameterContext, LoadQueryAliasResolutionContext aliasResolutionContext, boolean hadSubselectFetches) {
        this.resultSet = resultSet;
        this.session = session;
        this.loadPlan = loadPlan;
        this.readOnly = readOnly;
        this.queryParameters = queryParameters;
        this.namedParameterContext = namedParameterContext;
        this.aliasResolutionContext = aliasResolutionContext;
        this.hadSubselectFetches = hadSubselectFetches;
        if (useOptionalEntityKey) {
            this.dictatedRootEntityKey = ResultSetProcessorHelper.getOptionalObjectKey(queryParameters, session);
            if (this.dictatedRootEntityKey == null) {
                throw new HibernateException("Unable to resolve optional entity-key");
            }
        } else {
            this.dictatedRootEntityKey = null;
        }
    }

    @Override
    public SessionImplementor getSession() {
        return this.session;
    }

    @Override
    public QueryParameters getQueryParameters() {
        return this.queryParameters;
    }

    @Override
    public EntityKey getDictatedRootEntityKey() {
        return this.dictatedRootEntityKey;
    }

    @Override
    public ResultSetProcessingContext.IdentifierResolutionContext getIdentifierResolutionContext(final EntityReference entityReference) {
        ResultSetProcessingContext.IdentifierResolutionContext context;
        if (this.identifierResolutionContextMap == null) {
            this.identifierResolutionContextMap = new HashMap<EntityReference, ResultSetProcessingContext.IdentifierResolutionContext>();
        }
        if ((context = this.identifierResolutionContextMap.get(entityReference)) == null) {
            context = new ResultSetProcessingContext.IdentifierResolutionContext(){
                private Object hydratedForm;
                private EntityKey entityKey;

                @Override
                public EntityReference getEntityReference() {
                    return entityReference;
                }

                @Override
                public void registerHydratedForm(Object hydratedForm) {
                    if (this.hydratedForm != null) {
                        // empty if block
                    }
                    this.hydratedForm = hydratedForm;
                }

                @Override
                public Object getHydratedForm() {
                    return this.hydratedForm;
                }

                @Override
                public void registerEntityKey(EntityKey entityKey) {
                    if (this.entityKey != null) {
                        // empty if block
                    }
                    this.entityKey = entityKey;
                }

                @Override
                public EntityKey getEntityKey() {
                    return this.entityKey;
                }
            };
            this.identifierResolutionContextMap.put(entityReference, context);
        }
        return context;
    }

    @Override
    public Set<ResultSetProcessingContext.IdentifierResolutionContext> getIdentifierResolutionContexts() {
        return Collections.unmodifiableSet(new HashSet<ResultSetProcessingContext.IdentifierResolutionContext>(this.identifierResolutionContextMap.values()));
    }

    @Override
    public LoadQueryAliasResolutionContext getLoadQueryAliasResolutionContext() {
        return this.aliasResolutionContext;
    }

    @Override
    public void checkVersion(ResultSet resultSet, EntityPersister persister, EntityAliases entityAliases, EntityKey entityKey, Object entityInstance) {
        Object version = this.session.getPersistenceContext().getEntry(entityInstance).getVersion();
        if (version != null) {
            Object currentVersion;
            VersionType versionType = persister.getVersionType();
            try {
                currentVersion = versionType.nullSafeGet(resultSet, entityAliases.getSuffixedVersionAliases(), this.session, null);
            }
            catch (SQLException e) {
                throw this.getSession().getFactory().getJdbcServices().getSqlExceptionHelper().convert(e, "Could not read version value from result set");
            }
            if (!versionType.isEqual(version, currentVersion)) {
                if (this.session.getFactory().getStatistics().isStatisticsEnabled()) {
                    this.session.getFactory().getStatisticsImplementor().optimisticFailure(persister.getEntityName());
                }
                throw new StaleObjectStateException(persister.getEntityName(), entityKey.getIdentifier());
            }
        }
    }

    @Override
    public String getConcreteEntityTypeName(ResultSet rs, EntityPersister persister, EntityAliases entityAliases, EntityKey entityKey) {
        Object discriminatorValue;
        Loadable loadable = (Loadable)persister;
        if (!loadable.hasSubclasses()) {
            return persister.getEntityName();
        }
        try {
            discriminatorValue = loadable.getDiscriminatorType().nullSafeGet(rs, entityAliases.getSuffixedDiscriminatorAlias(), this.session, null);
        }
        catch (SQLException e) {
            throw this.getSession().getFactory().getJdbcServices().getSqlExceptionHelper().convert(e, "Could not read discriminator value from ResultSet");
        }
        String result = loadable.getSubclassForDiscriminatorValue(discriminatorValue);
        if (result == null) {
            throw new WrongClassException("Discriminator: " + discriminatorValue, entityKey.getIdentifier(), persister.getEntityName());
        }
        return result;
    }

    @Override
    public Object resolveEntityKey(EntityKey entityKey, ResultSetProcessingContext.EntityKeyResolutionContext entityKeyContext) {
        Object existing = this.getSession().getEntityUsingInterceptor(entityKey);
        if (existing != null) {
            LockMode requestedLockMode;
            if (!entityKeyContext.getEntityPersister().isInstance(existing)) {
                throw new WrongClassException("loaded object was of wrong class " + existing.getClass(), entityKey.getIdentifier(), entityKeyContext.getEntityPersister().getEntityName());
            }
            LockMode lockMode = requestedLockMode = entityKeyContext.getLockMode() == null ? LockMode.NONE : entityKeyContext.getLockMode();
            if (requestedLockMode != LockMode.NONE) {
                boolean isVersionCheckNeeded;
                LockMode currentLockMode = this.getSession().getPersistenceContext().getEntry(existing).getLockMode();
                boolean bl = isVersionCheckNeeded = entityKeyContext.getEntityPersister().isVersioned() && currentLockMode.lessThan(requestedLockMode);
                if (isVersionCheckNeeded) {
                    this.checkVersion(this.resultSet, entityKeyContext.getEntityPersister(), this.aliasResolutionContext.resolveEntityColumnAliases(entityKeyContext.getEntityReference()), entityKey, existing);
                    this.getSession().getPersistenceContext().getEntry(existing).setLockMode(requestedLockMode);
                }
            }
            return existing;
        }
        String concreteEntityTypeName = this.getConcreteEntityTypeName(this.resultSet, entityKeyContext.getEntityPersister(), this.aliasResolutionContext.resolveEntityColumnAliases(entityKeyContext.getEntityReference()), entityKey);
        Object entityInstance = this.getSession().instantiate(concreteEntityTypeName, entityKey.getIdentifier());
        LockMode requestedLockMode = entityKeyContext.getLockMode() == null ? LockMode.NONE : entityKeyContext.getLockMode();
        LockMode acquiredLockMode = requestedLockMode == LockMode.NONE ? LockMode.READ : requestedLockMode;
        this.loadFromResultSet(this.resultSet, entityInstance, concreteEntityTypeName, entityKey, this.aliasResolutionContext.resolveEntityColumnAliases(entityKeyContext.getEntityReference()), acquiredLockMode, entityKeyContext.getEntityPersister(), true, entityKeyContext.getEntityPersister().getEntityMetamodel().getEntityType());
        this.registerHydratedEntity(entityKeyContext.getEntityPersister(), entityKey, entityInstance);
        return entityInstance;
    }

    @Override
    public void loadFromResultSet(ResultSet resultSet, Object entityInstance, String concreteEntityTypeName, EntityKey entityKey, EntityAliases entityAliases, LockMode acquiredLockMode, EntityPersister rootPersister, boolean eagerFetch, EntityType associationType) {
        String ukName;
        Object rowId;
        Object[] values;
        Serializable id = entityKey.getIdentifier();
        Loadable persister = (Loadable)this.getSession().getFactory().getEntityPersister(concreteEntityTypeName);
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Initializing object from ResultSet: {0}", (Object)MessageHelper.infoString((EntityPersister)persister, id, this.getSession().getFactory()));
        }
        TwoPhaseLoad.addUninitializedEntity(entityKey, entityInstance, persister, acquiredLockMode, !eagerFetch, this.session);
        String[][] cols = persister == rootPersister ? entityAliases.getSuffixedPropertyAliases() : entityAliases.getSuffixedPropertyAliases(persister);
        try {
            values = persister.hydrate(resultSet, id, entityInstance, (Loadable)rootPersister, cols, eagerFetch, this.session);
        }
        catch (SQLException e) {
            throw this.getSession().getFactory().getJdbcServices().getSqlExceptionHelper().convert(e, "Could not read entity state from ResultSet : " + entityKey);
        }
        try {
            rowId = persister.hasRowId() ? resultSet.getObject(entityAliases.getRowIdAlias()) : null;
        }
        catch (SQLException e) {
            throw this.getSession().getFactory().getJdbcServices().getSqlExceptionHelper().convert(e, "Could not read entity row-id from ResultSet : " + entityKey);
        }
        if (associationType != null && (ukName = associationType.getRHSUniqueKeyPropertyName()) != null) {
            int index = ((UniqueKeyLoadable)persister).getPropertyIndex(ukName);
            Type type = persister.getPropertyTypes()[index];
            EntityUniqueKey euk = new EntityUniqueKey(rootPersister.getEntityName(), ukName, type.semiResolve(values[index], this.session, entityInstance), type, persister.getEntityMode(), this.session.getFactory());
            this.session.getPersistenceContext().addEntity(euk, entityInstance);
        }
        TwoPhaseLoad.postHydrate(persister, id, values, rowId, entityInstance, acquiredLockMode, !eagerFetch, this.session);
    }

    public void readCollectionElements(final Object[] row) {
        LoadPlanVisitor.visit(this.loadPlan, new LoadPlanVisitationStrategyAdapter(){

            @Override
            public void handleCollectionReturn(CollectionReturn rootCollectionReturn) {
                this.readCollectionElement(null, null, rootCollectionReturn.getCollectionPersister(), ResultSetProcessingContextImpl.this.aliasResolutionContext.resolveCollectionColumnAliases(rootCollectionReturn), ResultSetProcessingContextImpl.this.resultSet, ResultSetProcessingContextImpl.this.session);
            }

            @Override
            public void startingCollectionFetch(CollectionFetch collectionFetch) {
                Object owner = row[0];
                this.readCollectionElement(owner, collectionFetch.getCollectionPersister().getCollectionType().getKeyOfOwner(owner, ResultSetProcessingContextImpl.this.session), collectionFetch.getCollectionPersister(), ResultSetProcessingContextImpl.this.aliasResolutionContext.resolveCollectionColumnAliases(collectionFetch), ResultSetProcessingContextImpl.this.resultSet, ResultSetProcessingContextImpl.this.session);
            }

            private void readCollectionElement(Object optionalOwner, Serializable optionalKey, CollectionPersister persister, CollectionAliases descriptor, ResultSet rs, SessionImplementor session) {
                try {
                    PersistenceContext persistenceContext = session.getPersistenceContext();
                    Serializable collectionRowKey = (Serializable)persister.readKey(rs, descriptor.getSuffixedKeyAliases(), session);
                    if (collectionRowKey != null) {
                        PersistentCollection rowCollection;
                        Object owner;
                        if (LOG.isDebugEnabled()) {
                            LOG.debugf("Found row of collection: %s", (Object)MessageHelper.collectionInfoString(persister, collectionRowKey, session.getFactory()));
                        }
                        if ((owner = optionalOwner) != null || (owner = persistenceContext.getCollectionOwner(collectionRowKey, persister)) == null) {
                            // empty if block
                        }
                        if ((rowCollection = persistenceContext.getLoadContexts().getCollectionLoadContext(rs).getLoadingCollection(persister, collectionRowKey)) != null) {
                            rowCollection.readFrom(rs, persister, descriptor, owner);
                        }
                    } else if (optionalKey != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debugf("Result set contains (possibly empty) collection: %s", (Object)MessageHelper.collectionInfoString(persister, optionalKey, session.getFactory()));
                        }
                        persistenceContext.getLoadContexts().getCollectionLoadContext(rs).getLoadingCollection(persister, optionalKey);
                    }
                }
                catch (SQLException sqle) {
                    throw session.getFactory().getSQLExceptionHelper().convert(sqle, "could not read next row of results");
                }
            }
        });
    }

    @Override
    public void registerHydratedEntity(EntityPersister persister, EntityKey entityKey, Object entityInstance) {
        if (this.currentRowHydratedEntityRegistrationList == null) {
            this.currentRowHydratedEntityRegistrationList = new ArrayList<HydratedEntityRegistration>();
        }
        this.currentRowHydratedEntityRegistrationList.add(new HydratedEntityRegistration(persister, entityKey, entityInstance));
    }

    void finishUpRow() {
        if (this.currentRowHydratedEntityRegistrationList == null) {
            return;
        }
        if (this.hydratedEntityRegistrationList == null) {
            this.hydratedEntityRegistrationList = new ArrayList<HydratedEntityRegistration>();
        }
        this.hydratedEntityRegistrationList.addAll(this.currentRowHydratedEntityRegistrationList);
        if (this.hadSubselectFetches) {
            if (this.subselectLoadableEntityKeyMap == null) {
                this.subselectLoadableEntityKeyMap = new HashMap<EntityPersister, Set<EntityKey>>();
            }
            for (HydratedEntityRegistration registration : this.currentRowHydratedEntityRegistrationList) {
                Set<EntityKey> entityKeys = this.subselectLoadableEntityKeyMap.get(registration.persister);
                if (entityKeys == null) {
                    entityKeys = new HashSet<EntityKey>();
                    this.subselectLoadableEntityKeyMap.put(registration.persister, entityKeys);
                }
                entityKeys.add(registration.key);
            }
        }
        this.currentRowHydratedEntityRegistrationList.clear();
    }

    void finishUp(List<AfterLoadAction> afterLoadActionList) {
        this.initializeEntitiesAndCollections(afterLoadActionList);
        this.createSubselects();
        if (this.hydratedEntityRegistrationList != null) {
            this.hydratedEntityRegistrationList.clear();
            this.hydratedEntityRegistrationList = null;
        }
        if (this.subselectLoadableEntityKeyMap != null) {
            this.subselectLoadableEntityKeyMap.clear();
            this.subselectLoadableEntityKeyMap = null;
        }
    }

    private void initializeEntitiesAndCollections(List<AfterLoadAction> afterLoadActionList) {
        PostLoadEvent postLoadEvent;
        PreLoadEvent preLoadEvent;
        this.finishLoadingArrays();
        if (this.session.isEventSource()) {
            preLoadEvent = new PreLoadEvent((EventSource)this.session);
            postLoadEvent = new PostLoadEvent((EventSource)this.session);
        } else {
            preLoadEvent = null;
            postLoadEvent = null;
        }
        this.performTwoPhaseLoad(preLoadEvent);
        this.finishLoadingCollections();
        this.postLoad(postLoadEvent, afterLoadActionList);
    }

    private void finishLoadingArrays() {
        LoadPlanVisitor.visit(this.loadPlan, new LoadPlanVisitationStrategyAdapter(){

            @Override
            public void handleCollectionReturn(CollectionReturn rootCollectionReturn) {
                this.endLoadingArray(rootCollectionReturn.getCollectionPersister());
            }

            @Override
            public void startingCollectionFetch(CollectionFetch collectionFetch) {
                this.endLoadingArray(collectionFetch.getCollectionPersister());
            }

            private void endLoadingArray(CollectionPersister persister) {
                if (persister.isArray()) {
                    ResultSetProcessingContextImpl.this.session.getPersistenceContext().getLoadContexts().getCollectionLoadContext(ResultSetProcessingContextImpl.this.resultSet).endLoadingCollections(persister);
                }
            }
        });
    }

    private void performTwoPhaseLoad(PreLoadEvent preLoadEvent) {
        int numberOfHydratedObjects = this.hydratedEntityRegistrationList == null ? 0 : this.hydratedEntityRegistrationList.size();
        LOG.tracev("Total objects hydrated: {0}", (Object)numberOfHydratedObjects);
        if (this.hydratedEntityRegistrationList == null) {
            return;
        }
        for (HydratedEntityRegistration registration : this.hydratedEntityRegistrationList) {
            TwoPhaseLoad.initializeEntity(registration.instance, this.readOnly, this.session, preLoadEvent);
        }
    }

    private void finishLoadingCollections() {
        LoadPlanVisitor.visit(this.loadPlan, new LoadPlanVisitationStrategyAdapter(){

            @Override
            public void handleCollectionReturn(CollectionReturn rootCollectionReturn) {
                this.endLoadingCollection(rootCollectionReturn.getCollectionPersister());
            }

            @Override
            public void startingCollectionFetch(CollectionFetch collectionFetch) {
                this.endLoadingCollection(collectionFetch.getCollectionPersister());
            }

            private void endLoadingCollection(CollectionPersister persister) {
                if (!persister.isArray()) {
                    ResultSetProcessingContextImpl.this.session.getPersistenceContext().getLoadContexts().getCollectionLoadContext(ResultSetProcessingContextImpl.this.resultSet).endLoadingCollections(persister);
                }
            }
        });
    }

    private void postLoad(PostLoadEvent postLoadEvent, List<AfterLoadAction> afterLoadActionList) {
        if (this.hydratedEntityRegistrationList == null) {
            return;
        }
        for (HydratedEntityRegistration registration : this.hydratedEntityRegistrationList) {
            TwoPhaseLoad.postLoad(registration.instance, this.session, postLoadEvent);
            if (afterLoadActionList == null) continue;
            for (AfterLoadAction afterLoadAction : afterLoadActionList) {
                afterLoadAction.afterLoad(this.session, registration.instance, (Loadable)registration.persister);
            }
        }
    }

    private void createSubselects() {
        if (this.subselectLoadableEntityKeyMap == null || this.subselectLoadableEntityKeyMap.size() <= 1) {
            return;
        }
        Map<String, int[]> namedParameterLocMap = ResultSetProcessorHelper.buildNamedParameterLocMap(this.queryParameters, this.namedParameterContext);
        for (Map.Entry<EntityPersister, Set<EntityKey>> entry : this.subselectLoadableEntityKeyMap.entrySet()) {
            if (!entry.getKey().hasSubselectLoadableCollections()) continue;
            SubselectFetch subselectFetch = new SubselectFetch(null, (Loadable)entry.getKey(), this.queryParameters, entry.getValue(), namedParameterLocMap);
            for (EntityKey key : entry.getValue()) {
                this.session.getPersistenceContext().getBatchFetchQueue().addSubselect(key, subselectFetch);
            }
        }
    }

    private static class HydratedEntityRegistration {
        private final EntityPersister persister;
        private final EntityKey key;
        private final Object instance;

        private HydratedEntityRegistration(EntityPersister persister, EntityKey key, Object instance) {
            this.persister = persister;
            this.key = key;
            this.instance = instance;
        }
    }
}

