/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.loader.internal.ResultSetProcessingContextImpl;
import org.hibernate.loader.plan.spi.CollectionFetch;
import org.hibernate.loader.plan.spi.CollectionReturn;
import org.hibernate.loader.plan.spi.EntityFetch;
import org.hibernate.loader.plan.spi.LoadPlan;
import org.hibernate.loader.plan.spi.Return;
import org.hibernate.loader.plan.spi.visit.LoadPlanVisitationStrategyAdapter;
import org.hibernate.loader.plan.spi.visit.LoadPlanVisitor;
import org.hibernate.loader.spi.AfterLoadAction;
import org.hibernate.loader.spi.LoadPlanAdvisor;
import org.hibernate.loader.spi.LoadQueryAliasResolutionContext;
import org.hibernate.loader.spi.NamedParameterContext;
import org.hibernate.loader.spi.ResultSetProcessor;
import org.hibernate.loader.spi.ScrollableResultSetProcessor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.transform.ResultTransformer;
import org.jboss.logging.Logger;

public class ResultSetProcessorImpl
implements ResultSetProcessor {
    private static final Logger LOG = Logger.getLogger(ResultSetProcessorImpl.class);
    private final LoadPlan baseLoadPlan;
    private final boolean hadSubselectFetches;

    public ResultSetProcessorImpl(LoadPlan loadPlan) {
        this.baseLoadPlan = loadPlan;
        LocalVisitationStrategy strategy = new LocalVisitationStrategy();
        LoadPlanVisitor.visit(loadPlan, strategy);
        this.hadSubselectFetches = strategy.hadSubselectFetches;
    }

    @Override
    public ScrollableResultSetProcessor toOnDemandForm() {
        throw new NotYetImplementedException();
    }

    @Override
    public List extractResults(LoadPlanAdvisor loadPlanAdvisor, ResultSet resultSet, SessionImplementor session, QueryParameters queryParameters, NamedParameterContext namedParameterContext, LoadQueryAliasResolutionContext aliasResolutionContext, boolean returnProxies, boolean readOnly, ResultTransformer forcedResultTransformer, List<AfterLoadAction> afterLoadActionList) throws SQLException {
        int count;
        int maxRows;
        LoadPlan loadPlan = loadPlanAdvisor.advise(this.baseLoadPlan);
        if (loadPlan == null) {
            throw new IllegalStateException("LoadPlanAdvisor returned null");
        }
        this.handlePotentiallyEmptyCollectionRootReturns(loadPlan, queryParameters.getCollectionKeys(), resultSet, session);
        RowSelection selection = queryParameters.getRowSelection();
        if (LimitHelper.hasMaxRows(selection)) {
            maxRows = selection.getMaxRows();
            LOG.tracef("Limiting ResultSet processing to just %s rows", (Object)maxRows);
        } else {
            maxRows = Integer.MAX_VALUE;
        }
        ResultSetProcessingContextImpl context = new ResultSetProcessingContextImpl(resultSet, session, loadPlan, readOnly, false, queryParameters, namedParameterContext, aliasResolutionContext, this.hadSubselectFetches);
        ArrayList<Object[]> loadResults = new ArrayList<Object[]>();
        int rootReturnCount = loadPlan.getReturns().size();
        LOG.trace((Object)"Processing result set");
        for (count = 0; count < maxRows && resultSet.next(); ++count) {
            Object[] logicalRow;
            LOG.debugf("Starting ResultSet row #%s", (Object)count);
            if (rootReturnCount == 1) {
                loadPlan.getReturns().get(0).hydrate(resultSet, context);
                loadPlan.getReturns().get(0).resolve(resultSet, context);
                logicalRow = loadPlan.getReturns().get(0).read(resultSet, context);
                context.readCollectionElements(new Object[]{logicalRow});
            } else {
                for (Return rootReturn : loadPlan.getReturns()) {
                    rootReturn.hydrate(resultSet, context);
                }
                for (Return rootReturn : loadPlan.getReturns()) {
                    rootReturn.resolve(resultSet, context);
                }
                logicalRow = new Object[rootReturnCount];
                int pos = 0;
                for (Return rootReturn : loadPlan.getReturns()) {
                    logicalRow[pos] = rootReturn.read(resultSet, context);
                    ++pos;
                }
                context.readCollectionElements(logicalRow);
            }
            loadResults.add(logicalRow);
            context.finishUpRow();
        }
        LOG.tracev("Done processing result set ({0} rows)", (Object)count);
        context.finishUp(afterLoadActionList);
        session.getPersistenceContext().initializeNonLazyCollections();
        return loadResults;
    }

    private void handlePotentiallyEmptyCollectionRootReturns(LoadPlan loadPlan, Serializable[] collectionKeys, ResultSet resultSet, SessionImplementor session) {
        if (collectionKeys == null) {
            return;
        }
        CollectionPersister persister = ((CollectionReturn)loadPlan.getReturns().get(0)).getCollectionPersister();
        for (Serializable key : collectionKeys) {
            if (!LOG.isDebugEnabled()) continue;
            LOG.debugf("Preparing collection intializer : %s", (Object)MessageHelper.collectionInfoString(persister, key, session.getFactory()));
            session.getPersistenceContext().getLoadContexts().getCollectionLoadContext(resultSet).getLoadingCollection(persister, key);
        }
    }

    private class LocalVisitationStrategy
    extends LoadPlanVisitationStrategyAdapter {
        private boolean hadSubselectFetches = false;

        private LocalVisitationStrategy() {
        }

        @Override
        public void startingEntityFetch(EntityFetch entityFetch) {
        }

        @Override
        public void startingCollectionFetch(CollectionFetch collectionFetch) {
            this.hadSubselectFetches |= collectionFetch.getFetchStrategy().getStyle() == FetchStyle.SUBSELECT;
        }
    }
}

