/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import java.util.Arrays;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.FetchOwnerDelegate;
import org.hibernate.persister.walking.spi.WalkingException;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

public class CompositeFetchOwnerDelegate
implements FetchOwnerDelegate {
    private final SessionFactoryImplementor sessionFactory;
    private final CompositeType compositeType;
    private final String[] columnNames;

    public CompositeFetchOwnerDelegate(SessionFactoryImplementor sessionFactory, CompositeType compositeType, String[] columnNames) {
        this.sessionFactory = sessionFactory;
        this.compositeType = compositeType;
        this.columnNames = columnNames;
    }

    @Override
    public boolean isNullable(Fetch fetch) {
        return this.compositeType.getPropertyNullability()[this.determinePropertyIndex(fetch)];
    }

    @Override
    public Type getType(Fetch fetch) {
        return this.compositeType.getSubtypes()[this.determinePropertyIndex(fetch)];
    }

    @Override
    public String[] getColumnNames(Fetch fetch) {
        int begin = 0;
        String[] subColumnNames = null;
        for (int i = 0; i < this.compositeType.getSubtypes().length; ++i) {
            int columnSpan = this.compositeType.getSubtypes()[i].getColumnSpan(this.sessionFactory);
            subColumnNames = ArrayHelper.slice(this.columnNames, begin, columnSpan);
            if (this.compositeType.getPropertyNames()[i].equals(fetch.getOwnerPropertyName())) break;
            begin += columnSpan;
        }
        return subColumnNames;
    }

    private int determinePropertyIndex(Fetch fetch) {
        String[] subAttributeNames = this.compositeType.getPropertyNames();
        int subAttributeIndex = -1;
        for (int i = 0; i < subAttributeNames.length; ++i) {
            if (!subAttributeNames[i].equals(fetch.getOwnerPropertyName())) continue;
            subAttributeIndex = i;
            break;
        }
        if (subAttributeIndex == -1) {
            throw new WalkingException(String.format("Owner property [%s] not found in composite properties [%s]", fetch.getOwnerPropertyName(), Arrays.asList(subAttributeNames)));
        }
        return subAttributeIndex;
    }
}

