/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.util.Set;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.relational.AbstractAuxiliaryDatabaseObject;
import org.hibernate.metamodel.relational.Schema;

public class BasicAuxiliaryDatabaseObjectImpl
extends AbstractAuxiliaryDatabaseObject {
    private static final String CATALOG_NAME_PLACEHOLDER = "${catalog}";
    private static final String SCHEMA_NAME_PLACEHOLDER = "${schema}";
    private final Schema defaultSchema;
    private final String createString;
    private final String dropString;

    public BasicAuxiliaryDatabaseObjectImpl(Schema defaultSchema, String createString, String dropString, Set<String> dialectScopes) {
        super(dialectScopes);
        this.defaultSchema = defaultSchema;
        this.createString = createString;
        this.dropString = dropString;
    }

    @Override
    public String[] sqlCreateStrings(Dialect dialect) {
        return new String[]{BasicAuxiliaryDatabaseObjectImpl.injectCatalogAndSchema(this.createString, this.defaultSchema)};
    }

    @Override
    public String[] sqlDropStrings(Dialect dialect) {
        return new String[]{BasicAuxiliaryDatabaseObjectImpl.injectCatalogAndSchema(this.dropString, this.defaultSchema)};
    }

    private static String injectCatalogAndSchema(String ddlString, Schema schema) {
        String rtn = StringHelper.replace(ddlString, CATALOG_NAME_PLACEHOLDER, schema.getName().getCatalog().getName());
        rtn = StringHelper.replace(rtn, SCHEMA_NAME_PLACEHOLDER, schema.getName().getSchema().getName());
        return rtn;
    }
}

