/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.configuration;

import org.infinispan.configuration.BuiltBy;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.CacheStoreConfiguration;
import org.infinispan.configuration.cache.LegacyConfigurationAdaptor;
import org.infinispan.configuration.cache.LegacyLoaderAdapter;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.jdbc.configuration.AbstractJdbcCacheStoreConfiguration;
import org.infinispan.loaders.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.loaders.jdbc.configuration.JdbcStringBasedCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.LegacyConnectionFactoryAdaptor;
import org.infinispan.loaders.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStoreConfig;
import org.infinispan.util.TypedProperties;

@BuiltBy(value=JdbcStringBasedCacheStoreConfigurationBuilder.class)
public class JdbcStringBasedCacheStoreConfiguration
extends AbstractJdbcCacheStoreConfiguration
implements LegacyLoaderAdapter<JdbcStringBasedCacheStoreConfig> {
    private final String key2StringMapper;
    private final TableManipulationConfiguration table;

    protected JdbcStringBasedCacheStoreConfiguration(String key2StringMapper, TableManipulationConfiguration table, ConnectionFactoryConfiguration connectionFactory, long lockAcquistionTimeout, int lockConcurrencyLevel, boolean purgeOnStartup, boolean purgeSynchronously, int purgerThreads, boolean fetchPersistentState, boolean ignoreModifications, TypedProperties properties, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore) {
        super(connectionFactory, lockAcquistionTimeout, lockConcurrencyLevel, purgeOnStartup, purgeSynchronously, purgerThreads, fetchPersistentState, ignoreModifications, properties, async, singletonStore);
        this.key2StringMapper = key2StringMapper;
        this.table = table;
    }

    public String key2StringMapper() {
        return this.key2StringMapper;
    }

    public TableManipulationConfiguration table() {
        return this.table;
    }

    public JdbcStringBasedCacheStoreConfig adapt() {
        JdbcStringBasedCacheStoreConfig config = new JdbcStringBasedCacheStoreConfig();
        LegacyConfigurationAdaptor.adapt((CacheStoreConfiguration)this, (CacheStoreConfig)config);
        ((LegacyConnectionFactoryAdaptor)((Object)this.connectionFactory())).adapt(config);
        config.setKey2StringMapperClass(this.key2StringMapper);
        config.setCreateTableOnStart(this.table.createOnStart());
        config.setDropTableOnExit(this.table.dropOnExit());
        config.setBatchSize(this.table.batchSize());
        config.setFetchSize(this.table.fetchSize());
        config.setDatabaseType(this.table.databaseType());
        config.setCacheName(this.table.cacheName());
        config.setDataColumnName(this.table.dataColumnName());
        config.setDataColumnType(this.table.dataColumnType());
        config.setIdColumnName(this.table.idColumnName());
        config.setIdColumnType(this.table.idColumnType());
        config.setTimestampColumnName(this.table.timestampColumnName());
        config.setTimestampColumnType(this.table.timestampColumnType());
        config.setTableNamePrefix(this.table.tableNamePrefix());
        return config;
    }

    public String toString() {
        return "JdbcStringBasedCacheStoreConfiguration [key2StringMapper=" + this.key2StringMapper + ", table=" + this.table + ", connectionFactory()=" + this.connectionFactory() + ", lockAcquistionTimeout()=" + this.lockAcquistionTimeout() + ", lockConcurrencyLevel()=" + this.lockConcurrencyLevel() + ", async()=" + this.async() + ", singletonStore()=" + this.singletonStore() + ", purgeOnStartup()=" + this.purgeOnStartup() + ", purgeSynchronously()=" + this.purgeSynchronously() + ", purgerThreads()=" + this.purgerThreads() + ", fetchPersistentState()=" + this.fetchPersistentState() + ", ignoreModifications()=" + this.ignoreModifications() + ", properties()=" + this.properties() + "]";
    }
}

