/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.configuration;

import org.infinispan.configuration.BuiltBy;
import org.infinispan.loaders.jdbc.AbstractJdbcCacheStoreConfig;
import org.infinispan.loaders.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.loaders.jdbc.configuration.LegacyConnectionFactoryAdaptor;
import org.infinispan.loaders.jdbc.configuration.ManagedConnectionFactoryConfigurationBuilder;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.connectionfactory.ManagedConnectionFactory;

@BuiltBy(value=ManagedConnectionFactoryConfigurationBuilder.class)
public class ManagedConnectionFactoryConfiguration
implements ConnectionFactoryConfiguration,
LegacyConnectionFactoryAdaptor {
    private final String jndiUrl;

    ManagedConnectionFactoryConfiguration(String jndiUrl) {
        this.jndiUrl = jndiUrl;
    }

    public String jndiUrl() {
        return this.jndiUrl;
    }

    @Override
    public Class<? extends ConnectionFactory> connectionFactoryClass() {
        return ManagedConnectionFactory.class;
    }

    @Override
    public void adapt(AbstractJdbcCacheStoreConfig config) {
        config.setConnectionFactoryClass(this.connectionFactoryClass().getName());
        config.setDatasourceJndiLocation(this.jndiUrl);
    }

    public String toString() {
        return "ManagedConnectionFactoryConfiguration [jndiUrl=" + this.jndiUrl + "]";
    }
}

