/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.api.metadata.common;

import java.util.HashMap;
import java.util.Map;

public enum FlushStrategy {
    UNKNOWN(null),
    FAILING_CONNECTION_ONLY("FailingConnectionOnly"),
    IDLE_CONNECTIONS("IdleConnections"),
    ENTIRE_POOL("EntirePool");

    private final String name;
    private static final Map<String, FlushStrategy> MAP;

    private FlushStrategy(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static FlushStrategy forName(String name) {
        FlushStrategy element = MAP.get(name);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, FlushStrategy> map = new HashMap<String, FlushStrategy>();
        for (FlushStrategy element : FlushStrategy.values()) {
            String name = element.getName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

