/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.management.AccessConstraintDefinition;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.AuditLoggerInfo;
import org.jboss.as.jmx.ExposeModelResourceExpression;
import org.jboss.as.jmx.ExposeModelResourceResolved;
import org.jboss.as.jmx.JMXExtension;
import org.jboss.as.jmx.JMXSubsystemAdd;
import org.jboss.as.jmx.JMXSubsystemRemove;
import org.jboss.as.jmx.JmxAuditLoggerResourceDefinition;
import org.jboss.as.jmx.RemotingConnectorResource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JMXSubsystemRootResource
extends SimpleResourceDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"subsystem", (String)"jmx");
    private static final SimpleAttributeDefinition SHOW_MODEL_ALIAS = SimpleAttributeDefinitionBuilder.create((String)"show-model", (ModelType)ModelType.BOOLEAN, (boolean)true).addFlag(AttributeAccess.Flag.ALIAS).build();
    private final List<AccessConstraintDefinition> accessConstraints = JMXExtension.JMX_SENSITIVITY_DEF.wrapAsList();
    private final AuditLoggerInfo auditLoggerInfo;

    private JMXSubsystemRootResource(AuditLoggerInfo auditLoggerInfo) {
        super(PATH_ELEMENT, JMXExtension.getResourceDescriptionResolver("jmx"), (OperationStepHandler)new JMXSubsystemAdd(auditLoggerInfo), (OperationStepHandler)JMXSubsystemRemove.INSTANCE);
        this.auditLoggerInfo = auditLoggerInfo;
    }

    public static JMXSubsystemRootResource create(ManagedAuditLogger auditLogger) {
        return new JMXSubsystemRootResource(new AuditLoggerInfo(auditLogger));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SHOW_MODEL_ALIAS, (OperationStepHandler)ShowModelAliasReadHandler.INSTANCE, (OperationStepHandler)ShowModelAliasWriteHandler.INSTANCE);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new ExposeModelResourceResolved(this.auditLoggerInfo));
        resourceRegistration.registerSubModel((ResourceDefinition)new ExposeModelResourceExpression(this.auditLoggerInfo));
        resourceRegistration.registerSubModel((ResourceDefinition)RemotingConnectorResource.INSTANCE);
        resourceRegistration.registerSubModel((ResourceDefinition)new JmxAuditLoggerResourceDefinition(this.auditLoggerInfo.getAuditLogger()));
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    private static class ShowModelAliasReadHandler
    implements OperationStepHandler {
        static final ShowModelAliasReadHandler INSTANCE = new ShowModelAliasReadHandler();

        private ShowModelAliasReadHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
            context.getResult().set(resource.hasChild(PathElement.pathElement((String)"expose-model", (String)"resolved")));
            context.stepCompleted();
        }
    }

    private static class ShowModelAliasWriteHandler
    implements OperationStepHandler {
        static final ShowModelAliasWriteHandler INSTANCE = new ShowModelAliasWriteHandler();

        private ShowModelAliasWriteHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            boolean value = operation.get("value").asBoolean(false);
            boolean hasResource = context.readResource(PathAddress.EMPTY_ADDRESS).hasChild(ExposeModelResourceResolved.PATH_ELEMENT);
            if (value) {
                if (!hasResource) {
                    OperationStepHandler handler = context.getResourceRegistration().getOperationEntry(PathAddress.pathAddress((PathElement[])new PathElement[]{ExposeModelResourceResolved.PATH_ELEMENT}), "add").getOperationHandler();
                    ModelNode addOp = new ModelNode();
                    addOp.get("operation").set("add");
                    addOp.get("address").set(PathAddress.pathAddress((ModelNode)operation.get("address")).append(new PathElement[]{ExposeModelResourceResolved.PATH_ELEMENT}).toModelNode());
                    context.addStep(addOp, handler, OperationContext.Stage.MODEL, true);
                }
            } else if (hasResource) {
                OperationStepHandler handler = context.getResourceRegistration().getOperationEntry(PathAddress.pathAddress((PathElement[])new PathElement[]{ExposeModelResourceResolved.PATH_ELEMENT}), "remove").getOperationHandler();
                ModelNode addOp = new ModelNode();
                addOp.get("operation").set("remove");
                addOp.get("address").set(PathAddress.pathAddress((ModelNode)operation.get("address")).append(new PathElement[]{ExposeModelResourceResolved.PATH_ELEMENT}).toModelNode());
                context.addStep(addOp, handler, OperationContext.Stage.MODEL, true);
            }
            context.stepCompleted();
        }
    }
}

