/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.audit.AuditLogger;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.JMXExtension;
import org.jboss.as.jmx.JmxAuditLogHandlerReferenceResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JmxAuditLoggerResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"configuration", (String)"audit-log");
    public static final SimpleAttributeDefinition LOG_BOOT = new SimpleAttributeDefinitionBuilder("log-boot", ModelType.BOOLEAN, true).setAllowExpression(true).setDefaultValue(new ModelNode(true)).build();
    public static final SimpleAttributeDefinition LOG_READ_ONLY = new SimpleAttributeDefinitionBuilder("log-read-only", ModelType.BOOLEAN, true).setAllowExpression(true).setDefaultValue(new ModelNode(false)).build();
    public static final SimpleAttributeDefinition ENABLED = new SimpleAttributeDefinitionBuilder("enabled", ModelType.BOOLEAN, true).setAllowExpression(true).setDefaultValue(new ModelNode(true)).build();
    static final List<SimpleAttributeDefinition> ATTRIBUTE_DEFINITIONS = Arrays.asList(LOG_BOOT, LOG_READ_ONLY, ENABLED);
    private final ManagedAuditLogger auditLogger;

    public JmxAuditLoggerResourceDefinition(ManagedAuditLogger auditLogger) {
        super(PATH_ELEMENT, JMXExtension.getResourceDescriptionResolver("audit-log"), (OperationStepHandler)new AuditLoggerAddHandler(auditLogger), (OperationStepHandler)new AuditLoggerRemoveHandler(auditLogger));
        this.auditLogger = auditLogger;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)LOG_BOOT, null, (OperationStepHandler)new ModelOnlyWriteAttributeHandler(new AttributeDefinition[]{LOG_BOOT}));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)LOG_READ_ONLY, null, (OperationStepHandler)new AuditLogReadOnlyWriteAttributeHandler(this.auditLogger));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)ENABLED, null, (OperationStepHandler)new AuditLogEnabledWriteAttributeHandler(this.auditLogger));
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new JmxAuditLogHandlerReferenceResourceDefinition(this.auditLogger));
    }

    private static class AuditLogEnabledWriteAttributeHandler
    extends AbstractWriteAttributeHandler<AuditLogger.Status> {
        private final ManagedAuditLogger auditLogger;

        public AuditLogEnabledWriteAttributeHandler(ManagedAuditLogger auditLogger) {
            super(new AttributeDefinition[]{ENABLED});
            this.auditLogger = auditLogger;
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<AuditLogger.Status> handbackHolder) throws OperationFailedException {
            handbackHolder.setHandback((Object)this.auditLogger.getLoggerStatus());
            boolean enabled = resolvedValue.asBoolean();
            AuditLogger.Status status = enabled ? AuditLogger.Status.LOGGING : AuditLogger.Status.DISABLED;
            this.auditLogger.setLoggerStatus(status);
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, AuditLogger.Status handback) throws OperationFailedException {
            this.auditLogger.setLoggerStatus(handback);
        }
    }

    private static class AuditLogReadOnlyWriteAttributeHandler
    extends AbstractWriteAttributeHandler<Boolean> {
        private final ManagedAuditLogger auditLogger;

        AuditLogReadOnlyWriteAttributeHandler(ManagedAuditLogger auditLogger) {
            super(new AttributeDefinition[]{LOG_READ_ONLY});
            this.auditLogger = auditLogger;
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Boolean> handbackHolder) throws OperationFailedException {
            handbackHolder.setHandback((Object)this.auditLogger.isLogReadOnly());
            this.auditLogger.setLogReadOnly(resolvedValue.asBoolean());
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Boolean handback) throws OperationFailedException {
            this.auditLogger.setLogReadOnly(handback.booleanValue());
        }
    }

    private static class AuditLoggerRemoveHandler
    implements OperationStepHandler {
        private final ManagedAuditLogger auditLogger;

        AuditLoggerRemoveHandler(ManagedAuditLogger auditLogger) {
            this.auditLogger = auditLogger;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.removeResource(PathAddress.EMPTY_ADDRESS);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    final boolean wasReadOnly = AuditLoggerRemoveHandler.this.auditLogger.isLogReadOnly();
                    final AuditLogger.Status oldStatus = AuditLoggerRemoveHandler.this.auditLogger.getLoggerStatus();
                    AuditLoggerRemoveHandler.this.auditLogger.setLoggerStatus(AuditLogger.Status.DISABLE_NEXT);
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            AuditLoggerRemoveHandler.this.auditLogger.setLogReadOnly(wasReadOnly);
                            AuditLoggerRemoveHandler.this.auditLogger.setLoggerStatus(oldStatus);
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    }

    private static class AuditLoggerAddHandler
    implements OperationStepHandler {
        private final ManagedAuditLogger auditLoggerProvider;

        AuditLoggerAddHandler(ManagedAuditLogger auditLoggerProvider) {
            this.auditLoggerProvider = auditLoggerProvider;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
            final ModelNode model = resource.getModel();
            for (AttributeDefinition attributeDefinition : ATTRIBUTE_DEFINITIONS) {
                attributeDefinition.validateAndSet(operation, model);
            }
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    final boolean wasReadOnly = AuditLoggerAddHandler.this.auditLoggerProvider.isLogReadOnly();
                    final AuditLogger.Status oldStatus = AuditLoggerAddHandler.this.auditLoggerProvider.getLoggerStatus();
                    AuditLoggerAddHandler.this.auditLoggerProvider.setLogReadOnly(LOG_READ_ONLY.resolveModelAttribute(context, model).asBoolean());
                    boolean enabled = ENABLED.resolveModelAttribute(context, model).asBoolean();
                    AuditLoggerAddHandler.this.auditLoggerProvider.setLoggerStatus(enabled ? AuditLogger.Status.LOGGING : AuditLogger.Status.DISABLED);
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            AuditLoggerAddHandler.this.auditLoggerProvider.setLogReadOnly(wasReadOnly);
                            AuditLoggerAddHandler.this.auditLoggerProvider.setLoggerStatus(oldStatus);
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    }
}

