/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import org.jboss.as.controller.ModelController;
import org.jboss.as.jmx.AuditLoggerInfo;
import org.jboss.as.jmx.PluggableMBeanServerImpl;
import org.jboss.as.jmx.model.ConfiguredDomains;
import org.jboss.as.jmx.model.ModelControllerMBeanServerPlugin;
import org.jboss.as.server.Services;
import org.jboss.as.server.jmx.MBeanServerPlugin;
import org.jboss.as.server.jmx.PluggableMBeanServer;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class MBeanServerService
implements Service<PluggableMBeanServer> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"mbean", "server"});
    private final String resolvedDomainName;
    private final String expressionsDomainName;
    private final boolean legacyWithProperPropertyFormat;
    private final AuditLoggerInfo auditLoggerInfo;
    private final InjectedValue<ModelController> modelControllerValue = new InjectedValue();
    private PluggableMBeanServer mBeanServer;
    private MBeanServerPlugin showModelPlugin;

    private MBeanServerService(String resolvedDomainName, String expressionsDomainName, boolean legacyWithProperPropertyFormat, AuditLoggerInfo auditLoggerInfo) {
        this.resolvedDomainName = resolvedDomainName;
        this.expressionsDomainName = expressionsDomainName;
        this.legacyWithProperPropertyFormat = legacyWithProperPropertyFormat;
        this.auditLoggerInfo = auditLoggerInfo;
    }

    public static ServiceController<?> addService(ServiceTarget batchBuilder, String resolvedDomainName, String expressionsDomainName, boolean legacyWithProperPropertyFormat, AuditLoggerInfo auditLoggerInfo, ServiceListener<Object> ... listeners) {
        MBeanServerService service = new MBeanServerService(resolvedDomainName, expressionsDomainName, legacyWithProperPropertyFormat, auditLoggerInfo);
        return batchBuilder.addService(SERVICE_NAME, (Service)service).addListener(listeners).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(ServiceBuilder.DependencyType.OPTIONAL, Services.JBOSS_SERVER_CONTROLLER, ModelController.class, service.modelControllerValue).install();
    }

    public synchronized void start(StartContext context) throws StartException {
        MBeanServer platform = ManagementFactory.getPlatformMBeanServer();
        PluggableMBeanServerImpl pluggable = platform instanceof PluggableMBeanServerImpl ? (PluggableMBeanServerImpl)((Object)platform) : new PluggableMBeanServerImpl(platform);
        pluggable.setAuditLogger(this.auditLoggerInfo);
        if (this.resolvedDomainName != null || this.expressionsDomainName != null) {
            ConfiguredDomains configuredDomains = new ConfiguredDomains(this.resolvedDomainName, this.expressionsDomainName);
            this.showModelPlugin = new ModelControllerMBeanServerPlugin(configuredDomains, (ModelController)this.modelControllerValue.getValue(), this.legacyWithProperPropertyFormat);
            pluggable.addPlugin(this.showModelPlugin);
        }
        this.mBeanServer = pluggable;
    }

    public synchronized void stop(StopContext context) {
        this.mBeanServer.removePlugin(this.showModelPlugin);
        this.mBeanServer = null;
    }

    public synchronized PluggableMBeanServer getValue() throws IllegalStateException {
        return this.mBeanServer;
    }
}

