/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx.model;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;

class RootResourceIterator<T> {
    private final Resource rootResource;
    private final ResourceAction<T> action;

    RootResourceIterator(Resource rootResource, ResourceAction<T> action) {
        this.rootResource = rootResource;
        this.action = action;
    }

    T iterate() {
        this.doIterate(this.rootResource, PathAddress.EMPTY_ADDRESS);
        return this.action.getResult();
    }

    private void doIterate(Resource current, PathAddress address) {
        boolean handleChildren = false;
        if (this.action != null) {
            handleChildren = this.action.onResource(address);
        }
        if (handleChildren) {
            for (String type : current.getChildTypes()) {
                if (!current.hasChildren(type)) continue;
                for (Resource.ResourceEntry entry : current.getChildren(type)) {
                    PathElement pathElement = entry.getPathElement();
                    PathAddress childAddress = address.append(new PathElement[]{pathElement});
                    this.doIterate((Resource)entry, childAddress);
                }
            }
        }
    }

    static interface ResourceAction<T> {
        public boolean onResource(PathAddress var1);

        public T getResult();
    }
}

