/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import com.google.common.base.Defaults;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMember;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.IllegalProductException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.Reflections;

public abstract class AbstractProducerBean<X, T, S extends Member>
extends AbstractBean<T, S> {
    private final AbstractClassBean<X> declaringBean;
    private boolean passivationCapableBean;
    private boolean passivationCapableDependency;

    public AbstractProducerBean(BeanAttributes<T> attributes, String idSuffix, AbstractClassBean<X> declaringBean, BeanManagerImpl beanManager, ServiceRegistry services) {
        super(attributes, idSuffix, beanManager);
        this.declaringBean = declaringBean;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.getDeclaringBean().getBeanClass();
    }

    protected void initType() {
        try {
            this.type = this.getEnhancedAnnotated().getJavaClass();
        }
        catch (ClassCastException e) {
            Type type = Beans.getDeclaredBeanType(this.getClass());
            throw new WeldException(BeanMessage.PRODUCER_CAST_ERROR, (Throwable)e, this.getEnhancedAnnotated().getJavaClass(), type == null ? " unknown " : type);
        }
    }

    @Override
    public void internalInitialize(BeanDeployerEnvironment environment) {
        this.getDeclaringBean().initialize(environment);
        super.internalInitialize(environment);
        this.initPassivationCapable();
    }

    private void initPassivationCapable() {
        boolean bl = this.passivationCapableBean = !Reflections.isFinal(this.getEnhancedAnnotated().getJavaClass()) || Reflections.isSerializable(this.getEnhancedAnnotated().getJavaClass());
        this.passivationCapableDependency = this.isNormalScoped() ? true : this.getScope().equals(Dependent.class) && this.passivationCapableBean;
    }

    @Override
    public boolean isPassivationCapableBean() {
        return this.passivationCapableBean;
    }

    @Override
    public boolean isPassivationCapableDependency() {
        return this.passivationCapableDependency;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.getProducer().getInjectionPoints();
    }

    protected T checkReturnValue(T instance) {
        Class injectionPointRawType;
        InjectionPoint injectionPoint;
        if (instance == null && !this.isDependent()) {
            throw new IllegalProductException(BeanMessage.NULL_NOT_ALLOWED_FROM_PRODUCER, this.getProducer());
        }
        if (instance == null && (injectionPoint = (InjectionPoint)((CurrentInjectionPoint)this.beanManager.getServices().get(CurrentInjectionPoint.class)).peek()) != null && (injectionPointRawType = Reflections.getRawType(injectionPoint.getType())).isPrimitive()) {
            return Reflections.cast(Defaults.defaultValue(injectionPointRawType));
        }
        if (instance != null && !(instance instanceof Serializable)) {
            boolean passivating = this.beanManager.isPassivatingScope(this.getScope());
            if (passivating) {
                throw new IllegalProductException(BeanMessage.NON_SERIALIZABLE_PRODUCT_ERROR, this.getProducer());
            }
            InjectionPoint injectionPoint2 = (InjectionPoint)((CurrentInjectionPoint)this.beanManager.getServices().get(CurrentInjectionPoint.class)).peek();
            if (injectionPoint2 != null && injectionPoint2.getBean() != null && Beans.isPassivatingScope(injectionPoint2.getBean(), this.beanManager) && injectionPoint2.getMember() instanceof Field && !injectionPoint2.isTransient()) {
                throw new IllegalProductException(BeanMessage.NON_SERIALIZABLE_FIELD_INJECTION_ERROR, this, injectionPoint2);
            }
        }
        return instance;
    }

    @Override
    protected void checkType() {
        if (this.beanManager.isPassivatingScope(this.getScope()) && !this.isPassivationCapableBean()) {
            throw new DeploymentException(BeanMessage.PASSIVATING_BEAN_NEEDS_SERIALIZABLE_IMPL, this);
        }
    }

    protected boolean isTypeSerializable(Object instance) {
        return instance instanceof Serializable;
    }

    public T create(CreationalContext<T> creationalContext) {
        Object instance = this.getProducer().produce(creationalContext);
        instance = this.checkReturnValue(instance);
        return (T)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        try {
            this.getProducer().dispose(instance);
        }
        finally {
            if (this.getDeclaringBean().isDependent()) {
                creationalContext.release();
            }
        }
    }

    public AbstractClassBean<X> getDeclaringBean() {
        return this.declaringBean;
    }

    public abstract AnnotatedMember<? super X> getAnnotated();

    public abstract EnhancedAnnotatedMember<T, ?, S> getEnhancedAnnotated();
}

