/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.exceptions.NullInstanceException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;

public class CallableMethodHandler
implements MethodHandler,
Serializable {
    private static final long serialVersionUID = -1348302663981663427L;
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    private final Callable<?> callable;

    public CallableMethodHandler(Callable<?> callable) {
        this.callable = callable;
    }

    @Override
    public Object invoke(Object self, Method proxiedMethod, Method proceed, Object[] args) throws Throwable {
        Object instance = this.callable.call();
        if (instance == null) {
            throw new NullInstanceException(BeanMessage.NULL_INSTANCE, this.callable);
        }
        Object returnValue = Reflections.invokeAndUnwrap(instance, proxiedMethod, args);
        log.trace((Enum)BeanMessage.CALL_PROXIED_METHOD, new Object[]{proxiedMethod, instance, args, returnValue == null ? null : returnValue});
        return returnValue;
    }
}

