/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin.ee;

import java.lang.annotation.Annotation;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.servlet.ServletContext;
import org.jboss.weld.bean.builtin.AbstractStaticallyDecorableBuiltInBean;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.messages.ServletMessage;
import org.jboss.weld.manager.BeanManagerImpl;

public class ServletContextBean
extends AbstractStaticallyDecorableBuiltInBean<ServletContext> {
    private static ThreadLocal<ServletContext> servletContext = new ThreadLocal();

    public ServletContextBean(BeanManagerImpl beanManager) {
        super(ServletContextBean.class.getName(), beanManager, ServletContext.class);
    }

    @Override
    protected ServletContext newInstance(InjectionPoint ip, CreationalContext<ServletContext> creationalContext) {
        if (servletContext.get() == null) {
            throw new IllegalStateException(ServletMessage.CANNOT_INJECT_OBJECT_OUTSIDE_OF_SERVLET_REQUEST, ServletContext.class.getSimpleName());
        }
        return servletContext.get();
    }

    public void destroy(ServletContext instance, CreationalContext<ServletContext> creationalContext) {
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return RequestScoped.class;
    }

    public static void setServletContext(ServletContext ctx) {
        servletContext.set(ctx);
    }

    public static void cleanup() {
        servletContext.remove();
    }
}

