/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import com.google.common.cache.LoadingCache;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Priority;
import javax.decorator.Decorator;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.interceptor.Interceptor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStore;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.attributes.BeanAttributesFactory;
import org.jboss.weld.bean.interceptor.InterceptorBindingsAdapter;
import org.jboss.weld.bootstrap.AbstractBeanDeployer;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.BeanDeployerEnvironmentFactory;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.enablement.GlobalEnablementBuilder;
import org.jboss.weld.bootstrap.events.ProcessAnnotatedTypeImpl;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.ejb.spi.InterceptorBindings;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.injection.producer.InterceptionModelInitializer;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.cache.LoadingCacheUtils;
import org.jboss.weld.util.collections.Multimaps;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;
import org.slf4j.ext.XLogger;

public class BeanDeployer
extends AbstractBeanDeployer<BeanDeployerEnvironment> {
    private transient LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CLASS_LOADING);
    private transient XLogger xlog = LoggerFactory.loggerFactory().getXLogger(Category.CLASS_LOADING);
    private final ResourceLoader resourceLoader;
    private final SlimAnnotatedTypeStore annotatedTypeStore;
    private final GlobalEnablementBuilder globalEnablementBuilder;

    public BeanDeployer(BeanManagerImpl manager, EjbDescriptors ejbDescriptors, ServiceRegistry services) {
        this(manager, ejbDescriptors, services, BeanDeployerEnvironmentFactory.newEnvironment(ejbDescriptors, manager));
    }

    public BeanDeployer(BeanManagerImpl manager, EjbDescriptors ejbDescriptors, ServiceRegistry services, BeanDeployerEnvironment environment) {
        super(manager, services, environment);
        this.resourceLoader = (ResourceLoader)manager.getServices().get(ResourceLoader.class);
        this.annotatedTypeStore = (SlimAnnotatedTypeStore)manager.getServices().get(SlimAnnotatedTypeStore.class);
        this.globalEnablementBuilder = (GlobalEnablementBuilder)manager.getServices().get(GlobalEnablementBuilder.class);
    }

    public BeanDeployer addClass(String className) {
        SlimAnnotatedType<?> type;
        Class<?> clazz = this.loadClass(className);
        if (clazz != null && (type = this.loadAnnotatedType(clazz)) != null) {
            ((BeanDeployerEnvironment)this.getEnvironment()).addAnnotatedType(type);
        }
        return this;
    }

    private Class<?> loadClass(String className) {
        try {
            return this.resourceLoader.classForName(className);
        }
        catch (ResourceLoadingException e) {
            this.log.info((Enum)BootstrapMessage.IGNORING_CLASS_DUE_TO_LOADING_ERROR, new Object[]{className, Formats.getNameOfMissingClassLoaderDependency(e)});
            this.xlog.catching(XLogger.Level.DEBUG, (Throwable)e);
            return null;
        }
    }

    private <T> SlimAnnotatedType<T> loadAnnotatedType(Class<T> clazz) {
        if (clazz != null && !clazz.isAnnotation() && !Beans.isVetoed(clazz)) {
            this.containerLifecycleEvents.preloadProcessAnnotatedType(clazz);
            try {
                return this.classTransformer.getBackedAnnotatedType(clazz, this.getManager().getId());
            }
            catch (ResourceLoadingException e) {
                this.log.info((Enum)BootstrapMessage.IGNORING_CLASS_DUE_TO_LOADING_ERROR, new Object[]{clazz.getName(), Formats.getNameOfMissingClassLoaderDependency(e)});
                this.xlog.catching(XLogger.Level.DEBUG, (Throwable)e);
            }
        }
        return null;
    }

    private void processPriority(AnnotatedType<?> type) {
        Priority priority = (Priority)type.getAnnotation(Priority.class);
        if (priority != null) {
            int value = priority.value();
            if (type.isAnnotationPresent(Interceptor.class)) {
                this.globalEnablementBuilder.addInterceptor(type.getJavaClass(), value);
            } else if (type.isAnnotationPresent(Decorator.class)) {
                this.globalEnablementBuilder.addDecorator(type.getJavaClass(), value);
            } else {
                this.globalEnablementBuilder.addAlternative(type.getJavaClass(), value);
            }
        }
    }

    public <T> BeanDeployer addSyntheticClass(AnnotatedType<T> source, Extension extension, String suffix) {
        if (suffix == null) {
            suffix = AnnotatedTypes.createTypeId(source);
        }
        ((BeanDeployerEnvironment)this.getEnvironment()).addSyntheticAnnotatedType(this.classTransformer.getUnbackedAnnotatedType(source, this.getManager().getId(), suffix), extension);
        return this;
    }

    public BeanDeployer addClasses(Iterable<String> classes) {
        for (String className : classes) {
            this.addClass(className);
        }
        return this;
    }

    public void processAnnotatedTypes() {
        HashSet classesToBeAdded = new HashSet();
        HashSet classesToBeRemoved = new HashSet();
        for (SlimAnnotatedType<?> annotatedType : ((BeanDeployerEnvironment)this.getEnvironment()).getAnnotatedTypes()) {
            ProcessAnnotatedTypeImpl<?> event = this.containerLifecycleEvents.fireProcessAnnotatedType(this.getManager(), annotatedType, ((BeanDeployerEnvironment)this.getEnvironment()).getAnnotatedTypeSource(annotatedType));
            if (event != null) {
                if (event.isVeto()) {
                    ((BeanDeployerEnvironment)this.getEnvironment()).vetoJavaClass(annotatedType.getJavaClass());
                    classesToBeRemoved.add(annotatedType);
                    continue;
                }
                boolean dirty = event.isDirty();
                if (dirty) {
                    classesToBeRemoved.add(annotatedType);
                    classesToBeAdded.add(event.getResultingAnnotatedType());
                }
                this.processPriority(event.getResultingAnnotatedType());
                continue;
            }
            this.processPriority(annotatedType);
        }
        ((BeanDeployerEnvironment)this.getEnvironment()).removeAnnotatedTypes(classesToBeRemoved);
        ((BeanDeployerEnvironment)this.getEnvironment()).addAnnotatedTypes(classesToBeAdded);
    }

    public void registerAnnotatedTypes() {
        for (SlimAnnotatedType<?> type : ((BeanDeployerEnvironment)this.getEnvironment()).getAnnotatedTypes()) {
            this.annotatedTypeStore.put(type);
        }
    }

    public void createClassBeans() {
        LoadingCache otherWeldClasses = Multimaps.newConcurrentSetMultimap();
        for (SlimAnnotatedType<?> annotatedType : ((BeanDeployerEnvironment)this.getEnvironment()).getAnnotatedTypes()) {
            this.createClassBean(annotatedType, otherWeldClasses);
        }
        for (InternalEjbDescriptor ejbDescriptor : ((BeanDeployerEnvironment)this.getEnvironment()).getEjbDescriptors()) {
            if (((BeanDeployerEnvironment)this.getEnvironment()).isVetoed(ejbDescriptor.getBeanClass()) || Beans.isVetoed(ejbDescriptor.getBeanClass()) || !ejbDescriptor.isSingleton() && !ejbDescriptor.isStateful() && !ejbDescriptor.isStateless()) continue;
            if (otherWeldClasses.getIfPresent((Object)ejbDescriptor.getBeanClass()) != null) {
                for (SlimAnnotatedType annotatedType : LoadingCacheUtils.getCacheValue(otherWeldClasses, ejbDescriptor.getBeanClass())) {
                    EnhancedAnnotatedType weldClass = this.classTransformer.getEnhancedAnnotatedType(annotatedType);
                    this.createSessionBean(ejbDescriptor, (EnhancedAnnotatedType)Reflections.cast(weldClass));
                }
                continue;
            }
            this.createSessionBean(ejbDescriptor);
        }
    }

    protected void createClassBean(SlimAnnotatedType<?> annotatedType, LoadingCache<Class<?>, Set<SlimAnnotatedType<?>>> otherWeldClasses) {
        boolean managedBeanOrDecorator;
        boolean bl = managedBeanOrDecorator = !((BeanDeployerEnvironment)this.getEnvironment()).getEjbDescriptors().contains(annotatedType.getJavaClass()) && Beans.isTypeManagedBeanOrDecoratorOrInterceptor(annotatedType);
        if (managedBeanOrDecorator) {
            this.containerLifecycleEvents.preloadProcessInjectionTarget(annotatedType.getJavaClass());
            this.containerLifecycleEvents.preloadProcessBeanAttributes(annotatedType.getJavaClass());
            EnhancedAnnotatedType<?> weldClass = this.classTransformer.getEnhancedAnnotatedType(annotatedType);
            if (weldClass.isAnnotationPresent(Decorator.class)) {
                this.containerLifecycleEvents.preloadProcessBean(ProcessBean.class, annotatedType.getJavaClass());
                this.validateDecorator(weldClass);
                this.createDecorator(weldClass);
            } else if (weldClass.isAnnotationPresent(Interceptor.class)) {
                this.containerLifecycleEvents.preloadProcessBean(ProcessBean.class, annotatedType.getJavaClass());
                this.validateInterceptor(weldClass);
                this.createInterceptor(weldClass);
            } else if (!weldClass.isAbstract()) {
                this.containerLifecycleEvents.preloadProcessBean(ProcessManagedBean.class, annotatedType.getJavaClass());
                this.createManagedBean(weldClass);
            }
        } else {
            LoadingCacheUtils.getCacheValue(otherWeldClasses, annotatedType.getJavaClass()).add(annotatedType);
        }
    }

    public void processClassBeanAttributes() {
        this.preInitializeBeans(((BeanDeployerEnvironment)this.getEnvironment()).getClassBeans());
        this.preInitializeBeans(((BeanDeployerEnvironment)this.getEnvironment()).getDecorators());
        this.preInitializeBeans(((BeanDeployerEnvironment)this.getEnvironment()).getInterceptors());
        this.processBeanAttributes(((BeanDeployerEnvironment)this.getEnvironment()).getClassBeans());
        this.processBeanAttributes(((BeanDeployerEnvironment)this.getEnvironment()).getDecorators());
        this.processBeanAttributes(((BeanDeployerEnvironment)this.getEnvironment()).getInterceptors());
        this.searchForNewBeanDeclarations(((BeanDeployerEnvironment)this.getEnvironment()).getClassBeans());
        this.searchForNewBeanDeclarations(((BeanDeployerEnvironment)this.getEnvironment()).getDecorators());
        this.searchForNewBeanDeclarations(((BeanDeployerEnvironment)this.getEnvironment()).getInterceptors());
    }

    private void preInitializeBeans(Iterable<? extends AbstractBean<?, ?>> beans) {
        for (AbstractBean<?, ?> bean : beans) {
            bean.preInitialize();
        }
    }

    protected void processBeanAttributes(Iterable<? extends AbstractBean<?, ?>> beans) {
        if (!this.containerLifecycleEvents.isProcessBeanAttributesObserved()) {
            return;
        }
        if (!beans.iterator().hasNext()) {
            return;
        }
        HashSet vetoedBeans = new HashSet();
        HashSet previouslySpecializedBeans = new HashSet();
        for (AbstractBean<?, ?> abstractBean : beans) {
            boolean vetoed = this.fireProcessBeanAttributes(abstractBean);
            if (!vetoed) continue;
            vetoedBeans.add(abstractBean);
        }
        for (AbstractBean<Object, Object> abstractBean : vetoedBeans) {
            if (abstractBean.isSpecializing()) {
                previouslySpecializedBeans.addAll(this.specializationAndEnablementRegistry.resolveSpecializedBeans(abstractBean));
                this.specializationAndEnablementRegistry.vetoSpecializingBean(abstractBean);
            }
            ((BeanDeployerEnvironment)this.getEnvironment()).vetoBean(abstractBean);
        }
        this.processBeanAttributes(previouslySpecializedBeans);
    }

    protected void searchForNewBeanDeclarations(Iterable<? extends AbstractBean<?, ?>> beans) {
        for (AbstractBean<?, ?> bean : beans) {
            ((BeanDeployerEnvironment)this.getEnvironment()).addNewBeansFromInjectionPoints(bean);
        }
    }

    public void createProducersAndObservers() {
        for (AbstractClassBean<?> bean : ((BeanDeployerEnvironment)this.getEnvironment()).getClassBeans()) {
            this.createObserversProducersDisposers(bean);
        }
    }

    public void processProducerAttributes() {
        this.processBeanAttributes(((BeanDeployerEnvironment)this.getEnvironment()).getProducerFields());
        this.searchForNewBeanDeclarations(((BeanDeployerEnvironment)this.getEnvironment()).getProducerFields());
        this.preInitializeBeans(((BeanDeployerEnvironment)this.getEnvironment()).getProducerMethodBeans());
        this.processBeanAttributes(((BeanDeployerEnvironment)this.getEnvironment()).getProducerMethodBeans());
        this.searchForNewBeanDeclarations(((BeanDeployerEnvironment)this.getEnvironment()).getProducerMethodBeans());
    }

    public void createNewBeans() {
        for (EnhancedAnnotatedType<?> enhancedAnnotatedType : ((BeanDeployerEnvironment)this.getEnvironment()).getNewManagedBeanClasses()) {
            this.createNewManagedBean(enhancedAnnotatedType);
        }
        for (Map.Entry entry : ((BeanDeployerEnvironment)this.getEnvironment()).getNewSessionBeanDescriptorsFromInjectionPoint().entrySet()) {
            InternalEjbDescriptor descriptor = (InternalEjbDescriptor)((Object)entry.getKey());
            this.createNewSessionBean(descriptor, BeanAttributesFactory.forSessionBean((EnhancedAnnotatedType)entry.getValue(), descriptor, this.getManager()), (EnhancedAnnotatedType)entry.getValue());
        }
    }

    public void deploy() {
        this.initializeBeans();
        this.fireBeanEvents();
        this.deployBeans();
        this.initializeObserverMethods();
        this.deployObserverMethods();
    }

    protected void validateInterceptor(EnhancedAnnotatedType<?> weldClass) {
        if (weldClass.isAnnotationPresent(Decorator.class)) {
            throw new DeploymentException(BootstrapMessage.BEAN_IS_BOTH_INTERCEPTOR_AND_DECORATOR, weldClass.getName());
        }
    }

    protected void validateDecorator(EnhancedAnnotatedType<?> weldClass) {
        if (weldClass.isAnnotationPresent(Interceptor.class)) {
            throw new DefinitionException(BootstrapMessage.BEAN_IS_BOTH_INTERCEPTOR_AND_DECORATOR, weldClass.getName());
        }
    }

    public void doAfterBeanDiscovery(List<? extends Bean<?>> beanList) {
        for (Bean<?> bean : beanList) {
            if (!(bean instanceof RIBean)) continue;
            ((RIBean)bean).initializeAfterBeanDiscovery();
        }
    }

    public void registerCdiInterceptorsForMessageDrivenBeans() {
        EjbServices ejbServices = (EjbServices)this.getManager().getServices().get(EjbServices.class);
        for (InternalEjbDescriptor<?> descriptor : ((BeanDeployerEnvironment)this.getEnvironment()).getEjbDescriptors()) {
            InterceptionModel model;
            if (!descriptor.isMessageDriven()) continue;
            if (!this.getManager().getInterceptorModelRegistry().containsKey(descriptor.getBeanClass())) {
                InterceptionModelInitializer.of(this.getManager(), this.classTransformer.getEnhancedAnnotatedType(descriptor.getBeanClass(), this.getManager().getId()), null).init();
            }
            if ((model = (InterceptionModel)this.getManager().getInterceptorModelRegistry().get(descriptor.getBeanClass())) == null) continue;
            ejbServices.registerInterceptors(descriptor, (InterceptorBindings)new InterceptorBindingsAdapter(model));
        }
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void cleanup() {
        ((BeanDeployerEnvironment)this.getEnvironment()).cleanup();
    }
}

