/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import org.jboss.weld.bootstrap.events.AbstractDefinitionContainerEvent;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.Reflections;

public class ProcessObserverMethodImpl<T, X>
extends AbstractDefinitionContainerEvent
implements ProcessObserverMethod<T, X> {
    private final AnnotatedMethod<X> beanMethod;
    private final ObserverMethod<T> observerMethod;

    public static <T, X> void fire(BeanManagerImpl beanManager, ObserverMethodImpl<T, X> observer) {
        new ProcessObserverMethodImpl<T, X>(beanManager, (AnnotatedMethod)Reflections.cast(observer.getMethod().getAnnotated()), observer){}.fire();
    }

    public static <T> void fire(BeanManagerImpl beanManager, ObserverMethod<T> observer) {
        new ProcessObserverMethodImpl<T, Object>(beanManager, null, (ObserverMethod)observer){}.fire();
    }

    public ProcessObserverMethodImpl(BeanManagerImpl beanManager, AnnotatedMethod<X> beanMethod, ObserverMethod<T> observerMethod) {
        super(beanManager, (Type)((Object)ProcessObserverMethod.class), new Type[]{observerMethod.getObservedType(), observerMethod.getBeanClass()});
        this.beanMethod = beanMethod;
        this.observerMethod = observerMethod;
    }

    public void addDefinitionError(Throwable t) {
        this.getErrors().add(t);
    }

    public AnnotatedMethod<X> getAnnotatedMethod() {
        return this.beanMethod;
    }

    public ObserverMethod<T> getObserverMethod() {
        return this.observerMethod;
    }

    public List<Throwable> getDefinitionErrors() {
        return Collections.unmodifiableList(this.getErrors());
    }
}

