/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.enterprise.inject.spi.Annotated;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.logging.messages.UtilMessage;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.util.ApiAbstraction;

public class InterceptorsApiAbstraction
extends ApiAbstraction
implements Service {
    private final Class<? extends Annotation> INTERCEPTORS_ANNOTATION_CLASS = this.annotationTypeForName("javax.interceptor.Interceptors");
    private final Method interceptorsValueMethod;
    private final Class<? extends Annotation> EXCLUDE_CLASS_INTERCEPTORS_ANNOTATION_CLASS = this.annotationTypeForName("javax.interceptor.ExcludeClassInterceptors");

    public InterceptorsApiAbstraction(ResourceLoader resourceLoader) {
        super(resourceLoader);
        if (ApiAbstraction.DummyAnnotation.class.isAssignableFrom(this.INTERCEPTORS_ANNOTATION_CLASS)) {
            this.interceptorsValueMethod = null;
        } else {
            try {
                this.interceptorsValueMethod = this.INTERCEPTORS_ANNOTATION_CLASS.getMethod("value", new Class[0]);
            }
            catch (Exception e) {
                throw new DeploymentException(UtilMessage.ANNOTATION_VALUES_INACCESSIBLE, e, new Object[0]);
            }
        }
    }

    public Class<? extends Annotation> getInterceptorsAnnotationClass() {
        return this.INTERCEPTORS_ANNOTATION_CLASS;
    }

    public Class<? extends Annotation> getExcludeClassInterceptorsAnnotationClass() {
        return this.EXCLUDE_CLASS_INTERCEPTORS_ANNOTATION_CLASS;
    }

    public Class<?>[] extractInterceptorClasses(Annotated annotated) {
        Annotation annotation = annotated.getAnnotation(this.INTERCEPTORS_ANNOTATION_CLASS);
        if (annotation != null) {
            try {
                return (Class[])this.interceptorsValueMethod.invoke((Object)annotation, new Object[0]);
            }
            catch (Exception e) {
                throw new DeploymentException(UtilMessage.ANNOTATION_VALUES_INACCESSIBLE, e, new Object[0]);
            }
        }
        return null;
    }

    public void cleanup() {
    }
}

