/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.ajp;

import io.undertow.UndertowMessages;
import io.undertow.ajp.AjpSSLSessionInfo;
import io.undertow.server.AbstractServerConnection;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpContinue;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpTransferEncoding;
import io.undertow.server.SSLSessionInfo;
import io.undertow.server.ServerConnection;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.nio.ByteBuffer;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;

public final class AjpServerConnection
extends AbstractServerConnection
implements ServerConnection {
    private AjpSSLSessionInfo sslSessionInfo;

    public AjpServerConnection(StreamConnection channel, Pool<ByteBuffer> bufferPool, HttpHandler rootHandler, OptionMap undertowOptions, int bufferSize) {
        super(channel, bufferPool, rootHandler, undertowOptions, bufferSize);
    }

    @Override
    public HttpServerExchange sendOutOfBandResponse(HttpServerExchange exchange) {
        if (exchange == null || !HttpContinue.requiresContinueResponse(exchange)) {
            throw UndertowMessages.MESSAGES.outOfBandResponseOnlyAllowedFor100Continue();
        }
        final AbstractServerConnection.ConduitState state = this.resetChannel();
        HttpServerExchange newExchange = new HttpServerExchange(this);
        for (HttpString header : exchange.getRequestHeaders().getHeaderNames()) {
            newExchange.getRequestHeaders().putAll(header, exchange.getRequestHeaders().get(header));
        }
        newExchange.setProtocol(exchange.getProtocol());
        newExchange.setRequestMethod(exchange.getRequestMethod());
        newExchange.setRequestPath(exchange.getRequestPath());
        newExchange.getRequestHeaders().put(Headers.CONNECTION, Headers.KEEP_ALIVE.toString());
        newExchange.getRequestHeaders().put(Headers.CONTENT_LENGTH, 0L);
        HttpTransferEncoding.setupRequest(newExchange);
        newExchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

            @Override
            public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                AjpServerConnection.this.restoreChannel(state);
            }
        });
        return newExchange;
    }

    @Override
    public SSLSessionInfo getSslSessionInfo() {
        return this.sslSessionInfo;
    }

    void setSSLSessionInfo(AjpSSLSessionInfo sslSessionInfo) {
        this.sslSessionInfo = sslSessionInfo;
    }

    @Override
    public StreamConnection upgradeChannel() {
        throw UndertowMessages.MESSAGES.ajpDoesNotSupportHTTPUpgrade();
    }
}

