/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.CopyOnWriteMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;

public class PathHandler
implements HttpHandler {
    private volatile HttpHandler defaultHandler = ResponseCodeHandler.HANDLE_404;
    private final ConcurrentMap<String, HttpHandler> paths = new CopyOnWriteMap<String, HttpHandler>();
    private volatile int[] lengths = new int[0];

    public PathHandler(HttpHandler defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    public PathHandler() {
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String path = exchange.getRelativePath();
        int length = path.length();
        int[] lengths = this.lengths;
        for (int i = 0; i < lengths.length; ++i) {
            String part;
            HttpHandler next;
            char c;
            int pathLength = lengths[i];
            if (pathLength == length) {
                HttpHandler next2 = (HttpHandler)this.paths.get(path);
                if (next2 == null) continue;
                exchange.setRelativePath(path.substring(pathLength));
                exchange.setResolvedPath(exchange.getResolvedPath() + path);
                next2.handleRequest(exchange);
                return;
            }
            if (pathLength >= length || (c = path.charAt(pathLength)) != '/' || (next = (HttpHandler)this.paths.get(part = path.substring(0, pathLength))) == null) continue;
            exchange.setRelativePath(path.substring(pathLength));
            exchange.setResolvedPath(exchange.getResolvedPath() + part);
            next.handleRequest(exchange);
            return;
        }
        this.defaultHandler.handleRequest(exchange);
    }

    public synchronized PathHandler addPath(String path, HttpHandler handler) {
        HttpHandlers.handlerNotNull(handler);
        if (path.isEmpty()) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        if (path.equals("/")) {
            this.defaultHandler = handler;
            return this;
        }
        if (path.charAt(0) != '/') {
            this.paths.put("/" + path, handler);
        } else {
            this.paths.put(path, handler);
        }
        this.buildLengths();
        return this;
    }

    private void buildLengths() {
        TreeSet<Integer> lengths = new TreeSet<Integer>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return -o1.compareTo(o2);
            }
        });
        for (String p : this.paths.keySet()) {
            lengths.add(p.length());
        }
        int[] lengthArray = new int[lengths.size()];
        int pos = 0;
        Iterator i$ = lengths.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            lengthArray[pos++] = i;
        }
        this.lengths = lengthArray;
    }

    public synchronized PathHandler removePath(String path) {
        if (path == null || path.isEmpty()) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        if (path.equals("/")) {
            this.defaultHandler = ResponseCodeHandler.HANDLE_404;
            return this;
        }
        if (path.charAt(0) != '/') {
            this.paths.remove("/" + path);
        } else {
            this.paths.remove(path);
        }
        this.buildLengths();
        return this;
    }

    public synchronized PathHandler clearPaths() {
        this.paths.clear();
        this.lengths = new int[0];
        this.defaultHandler = ResponseCodeHandler.HANDLE_404;
        return this;
    }

    public Map<String, HttpHandler> getPaths() {
        return Collections.unmodifiableMap(this.paths);
    }
}

