/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol.version00;

import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.protocol.version00.WebSocket00Channel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xnio.Pooled;
import org.xnio.channels.PushBackStreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.PushBackStreamSourceConduit;

class WebSocket00TextFrameSourceChannel
extends StreamSourceFrameChannel {
    private static final byte END_FRAME_MARKER = -1;
    private final PushBackStreamSourceConduit pushBackStreamSourceConduit;
    private boolean complete;

    WebSocket00TextFrameSourceChannel(WebSocketChannel.StreamSourceChannelControl streamSourceChannelControl, StreamSourceChannel channel, WebSocket00Channel wsChannel, PushBackStreamSourceConduit pushBackStreamSourceConduit) {
        super(streamSourceChannelControl, channel, wsChannel, WebSocketFrameType.TEXT, -1L);
        this.pushBackStreamSourceConduit = pushBackStreamSourceConduit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferTo0(long position, long count, FileChannel target) throws IOException {
        if (this.complete) {
            return -1L;
        }
        if (count == 0L) {
            return 0L;
        }
        target.position(position);
        boolean free = true;
        Pooled pooled = this.wsChannel.getBufferPool().allocate();
        try {
            ByteBuffer buf = (ByteBuffer)pooled.getResource();
            buf.clear();
            long r = 0L;
            while (r < count) {
                int remaining = (int)(count - r);
                if (remaining < buf.limit()) {
                    buf.limit(remaining);
                }
                if (this.read(buf) > 0) {
                    buf.flip();
                    while (buf.hasRemaining()) {
                        int written = target.write(buf);
                        if (written == 0) {
                            if (buf.hasRemaining()) {
                                this.pushBackStreamSourceConduit.pushBack(pooled);
                                free = false;
                            }
                            long l = r;
                            return l;
                        }
                        r += (long)written;
                    }
                    buf.clear();
                    if (!this.complete) continue;
                    long l = r;
                    return l;
                }
                long l = r;
                return l;
            }
            long l = r;
            return l;
        }
        finally {
            if (free) {
                pooled.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferTo0(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        throughBuffer.clear();
        if (this.complete) {
            return -1L;
        }
        if (count == 0L) {
            return 0L;
        }
        try {
            if (count < (long)throughBuffer.limit()) {
                throughBuffer.limit((int)count);
            }
            long r = 0L;
            while (r < count) {
                int i = this.read(throughBuffer);
                if (i < 1) {
                    long l = r;
                    return l;
                }
                throughBuffer.flip();
                while (throughBuffer.hasRemaining()) {
                    int written = target.write(throughBuffer);
                    if (written == 0) {
                        long l = r;
                        return l;
                    }
                    r += (long)written;
                }
                throughBuffer.clear();
                long toRead = r - count;
                if (toRead < (long)throughBuffer.limit()) {
                    throughBuffer.limit((int)toRead);
                }
                if (!this.complete) continue;
                long l = r;
                return l;
            }
            long l = r;
            return l;
        }
        finally {
            throughBuffer.flip();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read0(ByteBuffer buf) throws IOException {
        int pos;
        if (this.complete) {
            return -1;
        }
        int r = this.channel.read(buf);
        int limit = pos + r;
        if (r == 1) {
            if (buf.get(pos) == -1) {
                this.complete = true;
                buf.position(pos + 1);
                return -1;
            }
        } else if (r > 1) {
            for (pos = buf.position(); pos < limit; ++pos) {
                if (buf.get(pos) != -1) continue;
                this.complete = true;
                if (pos + 1 < r) {
                    ByteBuffer remainingBytes = pos == 0 ? (ByteBuffer)buf.duplicate().position(1).limit(buf.limit()) : (ByteBuffer)buf.duplicate().position(pos + 1).limit(buf.limit() - pos + 1);
                    buf.position(pos);
                    Pooled pooled = this.wsChannel.getBufferPool().allocate();
                    ByteBuffer pooledBuf = (ByteBuffer)pooled.getResource();
                    pooledBuf.clear();
                    boolean failed = true;
                    try {
                        pooledBuf.put(remainingBytes).flip();
                        ((PushBackStreamChannel)this.channel).unget(pooled);
                        failed = false;
                    }
                    finally {
                        if (failed) {
                            pooled.free();
                        }
                    }
                    if (pos == 0) {
                        return -1;
                    }
                    return pos;
                }
                buf.position(pos);
                return r - pos + 1;
            }
            return r;
        }
        return r;
    }

    @Override
    public long read0(ByteBuffer[] bufs) throws IOException {
        return this.read0(bufs, 0, bufs.length);
    }

    @Override
    public long read0(ByteBuffer[] bufs, int index, int length) throws IOException {
        int i;
        if (this.complete) {
            return -1L;
        }
        long r = 0L;
        while (index < length && (i = this.read(bufs[index++])) > 0) {
            r += (long)i;
        }
        return r;
    }

    @Override
    protected boolean isComplete() {
        return this.complete;
    }
}

