/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.config;

import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.jacorb.config.Configuration;
import org.jacorb.config.JacORBLogFormatter;
import org.jacorb.config.LoggingInitializer;
import org.jacorb.util.ObjectUtil;

public class JdkLoggingInitializer
extends LoggingInitializer {
    private boolean usingJdkLogging() {
        try {
            Class c = ObjectUtil.classForName("org.slf4j.impl.JDK14LoggerAdapter");
            return c != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private Level toJdkLogLevel(String level) {
        if (level == null || level.length() == 0) {
            return Level.INFO;
        }
        try {
            int logLevel = Integer.parseInt(level.trim());
            switch (logLevel) {
                case 0: {
                    return Level.OFF;
                }
                case 1: {
                    return Level.SEVERE;
                }
                case 2: {
                    return Level.WARNING;
                }
                default: {
                    return Level.INFO;
                }
                case 4: 
            }
            return Level.FINEST;
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void init(Configuration config) {
        if (!this.usingJdkLogging()) {
            return;
        }
        String level = config.getAttribute("jacorb.log.default.verbosity", null);
        String file = config.getAttribute("jacorb.logfile", null);
        if (level != null && level.length() > 0 || file != null && file.length() > 0) {
            Logger rootLogger = Logger.getLogger("jacorb");
            rootLogger.setUseParentHandlers(false);
            rootLogger.setLevel(this.toJdkLogLevel(level));
            StreamHandler handler = new ConsoleHandler();
            if (file != null && file.length() > 0) {
                try {
                    handler = new FileHandler(this.substituteImplname(file, config), config.getAttributeAsBoolean("jacorb.logfile.append", false));
                }
                catch (IOException ex) {
                    System.err.println("could not write log file");
                }
            }
            handler.setLevel(this.toJdkLogLevel(level));
            handler.setFormatter(new JacORBLogFormatter());
            rootLogger.addHandler(handler);
        }
    }
}

