/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jacorb.imr.AdminPackage.IllegalServerName;
import org.jacorb.imr.ImRPOAInfo;
import org.jacorb.imr.POAInfo;
import org.jacorb.imr.ResourceLock;
import org.jacorb.imr.ServerInfo;

public class ImRServerInfo
implements Serializable {
    public static final long serialVersionUID = 1L;
    protected String command;
    protected boolean holding = false;
    protected String host;
    protected String name;
    protected boolean active;
    protected boolean restarting = false;
    private final List poas = new ArrayList();
    private ResourceLock poas_lock = null;

    public ImRServerInfo(String name, String host, String command) throws IllegalServerName {
        if (name == null || name.length() == 0) {
            throw new IllegalServerName(name);
        }
        this.name = name;
        this.host = host;
        this.command = command;
        this.active = false;
        this.poas_lock = new ResourceLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerInfo toServerInfo() {
        POAInfo[] _info;
        this.poas_lock.gainExclusiveLock();
        List list = this.poas;
        synchronized (list) {
            ImRPOAInfo[] _poas = this.poas.toArray(new ImRPOAInfo[this.poas.size()]);
            _info = new POAInfo[_poas.length];
            for (int i = 0; i < _info.length; ++i) {
                _info[i] = _poas[i].toPOAInfo();
            }
        }
        this.poas_lock.releaseExclusiveLock();
        return new ServerInfo(this.name, this.command, _info, this.host, this.active, this.holding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPOA(ImRPOAInfo poa) {
        if (!this.active) {
            this.active = true;
        }
        this.poas_lock.gainSharedLock();
        List list = this.poas;
        synchronized (list) {
            this.poas.add(poa);
        }
        this.poas_lock.releaseSharedLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getPOANames() {
        String[] names;
        List list = this.poas;
        synchronized (list) {
            ImRPOAInfo[] _poas = (ImRPOAInfo[])this.poas.toArray(new POAInfo[this.poas.size()]);
            names = new String[_poas.length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = _poas[i].name;
            }
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDown() {
        List list = this.poas;
        synchronized (list) {
            for (int _i = 0; _i < this.poas.size(); ++_i) {
                ((ImRPOAInfo)this.poas.get((int)_i)).active = false;
            }
        }
        this.active = false;
        this.restarting = false;
    }

    public synchronized void awaitRelease() {
        while (this.holding) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void release() {
        this.holding = false;
        this.notifyAll();
    }

    public synchronized boolean shouldBeRestarted() {
        boolean _restart;
        boolean bl = _restart = !this.active && !this.restarting;
        if (_restart) {
            this.restarting = true;
        }
        return _restart;
    }

    public void setNotRestarting() {
        this.restarting = false;
    }
}

