/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.MessageReceptorPool;
import org.jacorb.orb.giop.NoBiDirClientRequestListener;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.TransportManager;
import org.omg.CORBA.BAD_PARAM;
import org.omg.ETF.Factories;
import org.omg.ETF.Profile;
import org.slf4j.Logger;

public class ClientConnectionManager
implements Configurable {
    private final ORB orb;
    private final Map connections = new HashMap();
    private RequestListener request_listener;
    private MessageReceptorPool receptor_pool;
    private final TransportManager transport_manager;
    private final GIOPConnectionManager giop_connection_manager;
    private Logger logger;

    public ClientConnectionManager(ORB orb, TransportManager transport_manager, GIOPConnectionManager giop_connection_manager) {
        this.orb = orb;
        this.transport_manager = transport_manager;
        this.giop_connection_manager = giop_connection_manager;
    }

    public void configure(Configuration myConfiguration) throws ConfigurationException {
        this.receptor_pool = new MessageReceptorPool("client", "ClientMessageReceptor", myConfiguration);
        Configuration configuration = myConfiguration;
        this.logger = configuration.getLogger("jacorb.orb.giop");
        this.request_listener = new NoBiDirClientRequestListener(this.orb, this.logger);
    }

    public void setRequestListener(RequestListener listener) {
        this.request_listener = listener;
    }

    public synchronized ClientConnection getConnection(Profile profile) {
        ClientConnection clientConnection = (ClientConnection)this.connections.get(profile);
        if (clientConnection == null) {
            int tag = profile.tag();
            Factories factories = this.transport_manager.getFactories(tag);
            if (factories == null) {
                throw new BAD_PARAM("No transport plugin for profile tag " + tag);
            }
            GIOPConnection connection = this.giop_connection_manager.createClientGIOPConnection(profile, factories.create_connection(null), this.request_listener, null);
            clientConnection = new ClientConnection(connection, this.orb, this, profile, true);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("ClientConnectionManager: created new " + clientConnection.getGIOPConnection().toString());
            }
            this.receptor_pool.connectionCreated(connection);
            this.connections.put(profile, clientConnection);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("ClientConnectionManager: found " + clientConnection.getGIOPConnection().toString());
        }
        clientConnection.incClients();
        return clientConnection;
    }

    public synchronized void releaseConnection(ClientConnection connection) {
        if (connection.decClients()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ClientConnectionManager: releasing " + connection.getGIOPConnection().toString());
            }
            connection.close();
            this.connections.remove(connection.getRegisteredProfile());
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("ClientConnectionManager: cannot release " + connection.getGIOPConnection().toString() + " (still has " + connection.numClients() + " client(s))");
        }
    }

    public synchronized void removeConnection(ClientConnection connection) {
        this.connections.remove(connection.getRegisteredProfile());
    }

    public synchronized void addConnection(GIOPConnection connection, Profile profile) {
        if (!this.connections.containsKey(profile)) {
            ClientConnection clientConnection = new ClientConnection(connection, this.orb, this, profile, false);
            clientConnection.incClients();
            this.connections.put(profile, clientConnection);
        }
    }

    public synchronized void shutdown() {
        Iterator i = new HashSet(this.connections.values()).iterator();
        while (i.hasNext()) {
            ((ClientConnection)i.next()).close();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ClientConnectionManager shut down (all connections released)");
        }
        this.connections.clear();
        this.receptor_pool.shutdown();
    }
}

