/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import java.security.Provider;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.jacorb.security.sas.GSSUPContextSpi;
import org.jacorb.security.sas.GSSUPCredentialSpi;
import org.jacorb.security.sas.GSSUPNameSpi;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.jgss.spi.MechanismFactory;

public final class GSSUPMechFactory
implements MechanismFactory {
    protected static Provider myProvider;
    private Oid myMechOid;
    private Oid[] nameTypes = new Oid[]{GSSName.NT_EXPORT_NAME};

    public GSSUPMechFactory() {
        try {
            this.myMechOid = new Oid("2.23.130.1.1.1");
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
    }

    public Oid getMechanismOid() {
        return this.myMechOid;
    }

    public Provider getProvider() {
        return myProvider;
    }

    public Oid[] getNameTypes() {
        return this.nameTypes;
    }

    public GSSCredentialSpi getCredentialElement(GSSNameSpi name, int initLifetime, int acceptLifetime, int usage) throws GSSException {
        return new GSSUPCredentialSpi(myProvider, this.myMechOid, name, initLifetime, acceptLifetime, usage);
    }

    public GSSNameSpi getNameElement(String name, Oid nameTypeOid) throws GSSException {
        return this.getNameElement(name.getBytes(), nameTypeOid);
    }

    public GSSNameSpi getNameElement(byte[] name, Oid nameTypeOid) throws GSSException {
        return new GSSUPNameSpi(myProvider, this.myMechOid, name, nameTypeOid);
    }

    public GSSContextSpi getMechanismContext(GSSNameSpi nameSpi, GSSCredentialSpi credSpi, int lifetime) throws GSSException {
        return new GSSUPContextSpi(myProvider, this.myMechOid, nameSpi, credSpi, lifetime);
    }

    public GSSContextSpi getMechanismContext(GSSCredentialSpi credSpi) throws GSSException {
        return new GSSUPContextSpi(credSpi.getProvider(), credSpi.getMechanism(), credSpi.getName(), credSpi, credSpi.getInitLifetime());
    }

    public GSSContextSpi getMechanismContext(byte[] b1) throws GSSException {
        return null;
    }
}

