/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.rbac.ConfigurableRoleMapper;
import org.jboss.dmr.ModelNode;

public class RoleMappingAdd
implements OperationStepHandler {
    private final ConfigurableRoleMapper roleMapper;

    private RoleMappingAdd(ConfigurableRoleMapper roleMapper) {
        this.roleMapper = roleMapper;
    }

    public static OperationStepHandler create(ConfigurableRoleMapper roleMapper) {
        return new RoleMappingAdd(roleMapper);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.createResource(PathAddress.EMPTY_ADDRESS);
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String roleName = address.getLastElement().getValue().toUpperCase();
        this.registerRuntimeAdd(context, roleName);
        context.stepCompleted();
    }

    private void registerRuntimeAdd(OperationContext context, final String roleName) {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                if (context.isBooting()) {
                    RoleMappingAdd.this.roleMapper.addRoleImmediate(roleName);
                } else {
                    RoleMappingAdd.this.roleMapper.addRole(roleName);
                }
                RoleMappingAdd.this.registerRollbackHandler(context, roleName);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private void registerRollbackHandler(OperationContext context, final String roleName) {
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                Object undoKey = RoleMappingAdd.this.roleMapper.removeRole(roleName);
                if (undoKey == null) {
                    context.restartRequired();
                }
            }
        });
    }
}

