/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.core.security.ServerSecurityManager;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.as.domain.management.security.PasswordCredential;
import org.jboss.as.domain.management.security.SubjectCallback;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.sasl.callback.VerifyPasswordCallback;

public class JaasCallbackHandler
implements Service<CallbackHandlerService>,
CallbackHandlerService,
CallbackHandler {
    private static final Logger logger = Logger.getLogger(JaasCallbackHandler.class);
    public static final String SERVICE_SUFFIX = "jaas";
    private static final Map<String, String> configurationOptions;
    private final String name;
    private final InjectedValue<ServerSecurityManager> securityManagerValue = new InjectedValue();

    public JaasCallbackHandler(String name) {
        this.name = name;
    }

    @Override
    public AuthMechanism getPreferredMechanism() {
        return AuthMechanism.PLAIN;
    }

    @Override
    public Set<AuthMechanism> getSupplementaryMechanisms() {
        return Collections.emptySet();
    }

    @Override
    public Map<String, String> getConfigurationOptions() {
        return configurationOptions;
    }

    @Override
    public CallbackHandler getCallbackHandler(Map<String, Object> sharedState) {
        return this;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks.length == 1 && callbacks[0] instanceof AuthorizeCallback) {
            AuthorizeCallback acb = (AuthorizeCallback)callbacks[0];
            String authenticationId = acb.getAuthenticationID();
            String authorizationId = acb.getAuthorizationID();
            acb.setAuthorized(authenticationId.equals(authorizationId));
            return;
        }
        NameCallback nameCallBack = null;
        VerifyPasswordCallback verifyPasswordCallback = null;
        SubjectCallback subjectCallback = null;
        for (Callback current : callbacks) {
            if (current instanceof NameCallback) {
                nameCallBack = (NameCallback)current;
                continue;
            }
            if (current instanceof RealmCallback) continue;
            if (current instanceof VerifyPasswordCallback) {
                verifyPasswordCallback = (VerifyPasswordCallback)current;
                continue;
            }
            if (!(current instanceof SubjectCallback)) throw new UnsupportedCallbackException(current);
            subjectCallback = (SubjectCallback)current;
        }
        if (nameCallBack == null) {
            throw DomainManagementMessages.MESSAGES.noUsername();
        }
        final String userName = nameCallBack.getDefaultName();
        if (userName == null || userName.length() == 0) {
            throw DomainManagementMessages.MESSAGES.noUsername();
        }
        if (verifyPasswordCallback == null || verifyPasswordCallback.getPassword() == null) {
            throw DomainManagementMessages.MESSAGES.noPassword();
        }
        final char[] password = verifyPasswordCallback.getPassword().toCharArray();
        Subject subject = subjectCallback != null && subjectCallback.getSubject() != null ? subjectCallback.getSubject() : new Subject();
        ServerSecurityManager securityManager = (ServerSecurityManager)this.securityManagerValue.getOptionalValue();
        if (securityManager != null) {
            try {
                securityManager.push(this.name, userName, password, subject);
                securityManager.authenticate();
                verifyPasswordCallback.setVerified(true);
                subject.getPrivateCredentials().add(new PasswordCredential(userName, password));
                if (subjectCallback == null) return;
                subjectCallback.setSubject(subject);
                return;
            }
            catch (SecurityException e) {
                logger.debug((Object)("Failed to verify password in JAAS callbackhandler " + this.name), (Throwable)e);
                verifyPasswordCallback.setVerified(false);
                return;
            }
            finally {
                securityManager.pop();
            }
        }
        try {
            LoginContext ctx = new LoginContext(this.name, subject, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback current : callbacks) {
                        if (current instanceof NameCallback) {
                            NameCallback ncb = (NameCallback)current;
                            ncb.setName(userName);
                            continue;
                        }
                        if (current instanceof PasswordCallback) {
                            PasswordCallback pcb = (PasswordCallback)current;
                            pcb.setPassword(password);
                            continue;
                        }
                        throw new UnsupportedCallbackException(current);
                    }
                }
            });
            ctx.login();
            verifyPasswordCallback.setVerified(true);
            subject.getPrivateCredentials().add(new PasswordCredential(userName, password));
            if (subjectCallback == null) return;
            subjectCallback.setSubject(subject);
            return;
        }
        catch (LoginException e) {
            logger.debug((Object)("Login failed in JAAS callbackhandler " + this.name), (Throwable)e);
            verifyPasswordCallback.setVerified(false);
        }
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public InjectedValue<ServerSecurityManager> getSecurityManagerValue() {
        return this.securityManagerValue;
    }

    public CallbackHandlerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    static {
        HashMap<String, String> temp = new HashMap<String, String>(2);
        temp.put("org.jboss.as.domain.management.subject_callback_supported", Boolean.TRUE.toString());
        temp.put("org.jboss.as.domain.management.verify_password_callback_supported", Boolean.TRUE.toString());
        configurationOptions = Collections.unmodifiableMap(temp);
    }
}

