/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.domain.management.access.RbacSanityCheckOperation;
import org.jboss.as.domain.management.security.AuthenticationValidatingHandler;
import org.jboss.as.domain.management.security.SecurityRealmParentRestartHandler;
import org.jboss.dmr.ModelNode;

public class SecurityRealmChildRemoveHandler
extends SecurityRealmParentRestartHandler {
    private final boolean validateAuthentication;
    private final boolean validateRbac;

    public SecurityRealmChildRemoveHandler(boolean validateAuthentication, boolean validateRbac) {
        this.validateAuthentication = validateAuthentication;
        this.validateRbac = validateRbac;
    }

    protected void updateModel(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        if (this.validateAuthentication && !context.isBooting()) {
            ModelNode validationOp = AuthenticationValidatingHandler.createOperation(operation);
            context.addStep(validationOp, (OperationStepHandler)AuthenticationValidatingHandler.INSTANCE, OperationContext.Stage.MODEL);
        }
        if (this.validateRbac) {
            RbacSanityCheckOperation.registerOperation(context);
        }
    }
}

