/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.adduser;

import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.adduser.AddUserState;
import org.jboss.as.domain.management.security.adduser.ConfirmationChoice;
import org.jboss.as.domain.management.security.adduser.ConsoleWrapper;
import org.jboss.as.domain.management.security.adduser.PromptNewUserState;
import org.jboss.as.domain.management.security.adduser.State;
import org.jboss.as.domain.management.security.adduser.StateValues;
import org.jboss.as.domain.management.security.adduser.UpdateUser;

public class PreModificationState
implements State {
    private final ConsoleWrapper theConsole;
    private StateValues stateValues;

    public PreModificationState(ConsoleWrapper theConsole, StateValues stateValues) {
        this.theConsole = theConsole;
        this.stateValues = stateValues;
        if (!stateValues.isSilent() && theConsole.getConsole() == null) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
    }

    @Override
    public State execute() {
        State continuingState;
        if (this.stateValues.isExistingUser()) {
            continuingState = new UpdateUser(this.theConsole, this.stateValues);
        } else {
            AddUserState addState = new AddUserState(this.theConsole, this.stateValues);
            if (this.stateValues.isSilentOrNonInteractive()) {
                continuingState = addState;
            } else {
                String message = DomainManagementMessages.MESSAGES.aboutToAddUser(this.stateValues.getUserName(), this.stateValues.getRealm());
                String prompt = DomainManagementMessages.MESSAGES.isCorrectPrompt() + " " + DomainManagementMessages.MESSAGES.yes() + "/" + DomainManagementMessages.MESSAGES.no() + "?";
                continuingState = new ConfirmationChoice(this.theConsole, message, prompt, (State)addState, (State)new PromptNewUserState(this.theConsole, this.stateValues));
            }
        }
        return continuingState;
    }
}

