/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.FacesFileNotFoundException;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.FacesLogger;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.PhaseId;
import javax.faces.event.SystemEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionHandlerImpl
extends ExceptionHandler {
    private static final Logger LOGGER = FacesLogger.CONTEXT.getLogger();
    private static final String LOG_BEFORE_KEY = "jsf.context.exception.handler.log_before";
    private static final String LOG_AFTER_KEY = "jsf.context.exception.handler.log_after";
    private static final String LOG_KEY = "jsf.context.exception.handler.log";
    public static final Level INCIDENT_ERROR = Level.parse(Integer.toString(Level.SEVERE.intValue() + 100));
    private LinkedList<ExceptionQueuedEvent> unhandledExceptions;
    private LinkedList<ExceptionQueuedEvent> handledExceptions;
    private ExceptionQueuedEvent handled;
    private boolean errorPagePresent;

    public ExceptionHandlerImpl() {
        this.errorPagePresent = true;
    }

    public ExceptionHandlerImpl(boolean errorPagePresent) {
        this.errorPagePresent = errorPagePresent;
    }

    public ExceptionQueuedEvent getHandledExceptionQueuedEvent() {
        return this.handled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() throws FacesException {
        Iterator<ExceptionQueuedEvent> i = this.getUnhandledExceptionQueuedEvents().iterator();
        while (i.hasNext()) {
            ExceptionQueuedEvent event = i.next();
            ExceptionQueuedEventContext context = (ExceptionQueuedEventContext)event.getSource();
            try {
                Throwable t = context.getException();
                if (this.isRethrown(t)) {
                    this.handled = event;
                    Throwable unwrapped = this.getRootCause(t);
                    if (unwrapped != null) {
                        this.throwIt(context.getContext(), new FacesException(unwrapped.getMessage(), unwrapped));
                    } else if (t instanceof FacesException) {
                        this.throwIt(context.getContext(), (FacesException)t);
                    } else {
                        this.throwIt(context.getContext(), new FacesException(t.getMessage(), t));
                    }
                    if (!LOGGER.isLoggable(INCIDENT_ERROR)) continue;
                    this.log(context);
                    continue;
                }
                this.log(context);
            }
            finally {
                if (this.handledExceptions == null) {
                    this.handledExceptions = new LinkedList();
                }
                this.handledExceptions.add(event);
                i.remove();
            }
        }
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof ExceptionQueuedEventContext;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (event != null) {
            if (this.unhandledExceptions == null) {
                this.unhandledExceptions = new LinkedList();
            }
            this.unhandledExceptions.add((ExceptionQueuedEvent)event);
        }
    }

    public Throwable getRootCause(Throwable t) {
        if (t == null) {
            return null;
        }
        if (this.shouldUnwrap(t.getClass())) {
            Throwable root = t.getCause();
            if (root != null) {
                Throwable tmp = this.getRootCause(root);
                if (tmp == null) {
                    return root;
                }
                return tmp;
            }
            return t;
        }
        return t;
    }

    public Iterable<ExceptionQueuedEvent> getUnhandledExceptionQueuedEvents() {
        return this.unhandledExceptions != null ? this.unhandledExceptions : Collections.emptyList();
    }

    public Iterable<ExceptionQueuedEvent> getHandledExceptionQueuedEvents() {
        return this.handledExceptions != null ? this.handledExceptions : Collections.emptyList();
    }

    private void throwIt(FacesContext ctx, FacesException fe) {
        Throwable wrapped;
        ExternalContext extContext;
        boolean isDevelopment;
        block6: {
            isDevelopment = ctx.isProjectStage(ProjectStage.Development);
            extContext = ctx.getExternalContext();
            wrapped = fe.getCause();
            try {
                extContext.responseReset();
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.INFO)) break block6;
                LOGGER.log(Level.INFO, "Exception when handling error trying to reset the response.", wrapped);
            }
        }
        if (null != wrapped && wrapped instanceof FacesFileNotFoundException) {
            extContext.setResponseStatus(404);
        } else {
            extContext.setResponseStatus(500);
        }
        if (!isDevelopment || this.errorPagePresent) {
            if (isDevelopment) {
                ctx.getExternalContext().getRequestMap().put("com.sun.faces.error.view", ctx.getViewRoot());
            }
            throw fe;
        }
        RenderKitUtils.renderHtmlErrorPage(ctx, fe);
    }

    private boolean shouldUnwrap(Class<? extends Throwable> c) {
        return FacesException.class.equals(c) || ELException.class.equals(c);
    }

    private boolean isRethrown(Throwable t) {
        return !(t instanceof AbortProcessingException);
    }

    private void log(ExceptionQueuedEventContext exceptionContext) {
        Level level;
        UIComponent c = exceptionContext.getComponent();
        boolean beforePhase = exceptionContext.inBeforePhase();
        boolean afterPhase = exceptionContext.inAfterPhase();
        PhaseId phaseId = exceptionContext.getPhaseId();
        Throwable t = exceptionContext.getException();
        String key = this.getLoggingKey(beforePhase, afterPhase);
        Level level2 = level = LOGGER.isLoggable(INCIDENT_ERROR) && LOGGER.isLoggable(Level.SEVERE) ? INCIDENT_ERROR : Level.SEVERE;
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, key, new Object[]{t.getClass().getName(), phaseId.toString(), c != null ? c.getClientId(exceptionContext.getContext()) : "", t.getMessage()});
            LOGGER.log(level, t.getMessage(), t);
        }
    }

    private String getLoggingKey(boolean beforePhase, boolean afterPhase) {
        if (beforePhase) {
            return LOG_BEFORE_KEY;
        }
        if (afterPhase) {
            return LOG_AFTER_KEY;
        }
        return LOG_KEY;
    }
}

