/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.component;

import com.sun.faces.facelets.tag.IterationStatus;
import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.ContextCallback;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UINamingContainer;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreValidateEvent;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.ResultSetDataModel;
import javax.faces.model.ScalarDataModel;
import javax.faces.render.Renderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIRepeat
extends UINamingContainer {
    public static final String COMPONENT_TYPE = "facelets.ui.Repeat";
    public static final String COMPONENT_FAMILY = "facelets";
    private static final DataModel EMPTY_MODEL = new ListDataModel(Collections.emptyList());
    private Object value;
    private transient DataModel model;
    private String var;
    private String varStatus;
    private int index = -1;
    private Integer begin;
    private Integer end;
    private Integer step;
    private Integer size;
    private transient StringBuffer buffer;
    private transient Object origValueOfVar;
    private transient Object origValueOfVarStatus;
    private Map<String, SavedState> childState;
    private static final SavedState NullState = new SavedState();

    public UIRepeat() {
        this.setRendererType(COMPONENT_TYPE);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public void setEnd(Integer end) {
        this.end = end;
    }

    public Integer getEnd() {
        if (this.end != null) {
            return this.end;
        }
        ValueExpression ve = this.getValueExpression("end");
        if (ve != null) {
            return (Integer)ve.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Integer getSize() {
        if (this.size != null) {
            return this.size;
        }
        ValueExpression ve = this.getValueExpression("size");
        if (ve != null) {
            return (Integer)ve.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOffset(Integer offset) {
        this.begin = offset;
    }

    public Integer getOffset() {
        if (this.begin != null) {
            return this.begin;
        }
        ValueExpression ve = this.getValueExpression("offset");
        if (ve != null) {
            return (Integer)ve.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setBegin(Integer begin) {
        this.begin = begin;
    }

    public Integer getBegin() {
        if (this.begin != null) {
            return this.begin;
        }
        ValueExpression ve = this.getValueExpression("begin");
        if (ve != null) {
            return (Integer)ve.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStep(Integer step) {
        this.step = step;
    }

    public Integer getStep() {
        if (this.step != null) {
            return this.step;
        }
        ValueExpression ve = this.getValueExpression("step");
        if (ve != null) {
            return (Integer)ve.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getVarStatus() {
        return this.varStatus;
    }

    public void setVarStatus(String varStatus) {
        this.varStatus = varStatus;
    }

    private void resetDataModel() {
        if (this.isNestedInIterator()) {
            this.setDataModel(null);
        }
    }

    private void setDataModel(DataModel model) {
        this.model = model;
    }

    private DataModel getDataModel() {
        if (this.model == null) {
            Object val = this.getValue();
            this.model = val == null ? EMPTY_MODEL : (val instanceof DataModel ? (DataModel)val : (val instanceof List ? new ListDataModel((List)val) : (Object[].class.isAssignableFrom(val.getClass()) ? new ArrayDataModel((Object[])val) : (val instanceof ResultSet ? new ResultSetDataModel((ResultSet)val) : new ScalarDataModel(val)))));
        }
        return this.model;
    }

    public Object getValue() {
        ValueExpression ve;
        if (this.value == null && (ve = this.getValueExpression("value")) != null) {
            return ve.getValue(this.getFacesContext().getELContext());
        }
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    private StringBuffer getBuffer() {
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
        }
        this.buffer.setLength(0);
        return this.buffer;
    }

    public String getClientId(FacesContext faces) {
        String id = super.getClientId(faces);
        if (this.index >= 0) {
            id = this.getBuffer().append(id).append(UIRepeat.getSeparatorChar((FacesContext)faces)).append(this.index).toString();
        }
        return id;
    }

    private void captureOrigValue(FacesContext ctx) {
        if (this.var != null || this.varStatus != null) {
            Map attrs = ctx.getExternalContext().getRequestMap();
            if (this.var != null) {
                this.origValueOfVar = attrs.get(this.var);
            }
            if (this.varStatus != null) {
                this.origValueOfVarStatus = attrs.get(this.varStatus);
            }
        }
    }

    private void restoreOrigValue(FacesContext ctx) {
        if (this.var != null || this.varStatus != null) {
            Map attrs = ctx.getExternalContext().getRequestMap();
            if (this.var != null) {
                if (this.origValueOfVar != null) {
                    attrs.put(this.var, this.origValueOfVar);
                } else {
                    attrs.remove(this.var);
                }
            }
            if (this.varStatus != null) {
                if (this.origValueOfVarStatus != null) {
                    attrs.put(this.varStatus, this.origValueOfVarStatus);
                } else {
                    attrs.remove(this.varStatus);
                }
            }
        }
    }

    private Map<String, SavedState> getChildState() {
        if (this.childState == null) {
            this.childState = new HashMap<String, SavedState>();
        }
        return this.childState;
    }

    private void clearChildState() {
        this.childState = null;
    }

    private void saveChildState(FacesContext ctx) {
        if (this.getChildCount() > 0) {
            for (UIComponent uiComponent : this.getChildren()) {
                this.saveChildState(ctx, uiComponent);
            }
        }
    }

    private void saveChildState(FacesContext faces, UIComponent c) {
        if (c instanceof EditableValueHolder && !c.isTransient()) {
            String clientId = c.getClientId(faces);
            SavedState ss = this.getChildState().get(clientId);
            if (ss == null) {
                ss = new SavedState();
                this.getChildState().put(clientId, ss);
            }
            ss.populate((EditableValueHolder)c);
        }
        Iterator itr = c.getFacetsAndChildren();
        while (itr.hasNext()) {
            this.saveChildState(faces, (UIComponent)itr.next());
        }
    }

    private void restoreChildState(FacesContext ctx) {
        if (this.getChildCount() > 0) {
            for (UIComponent uiComponent : this.getChildren()) {
                this.restoreChildState(ctx, uiComponent);
            }
        }
    }

    private void restoreChildState(FacesContext faces, UIComponent c) {
        String id = c.getId();
        c.setId(id);
        if (c instanceof EditableValueHolder) {
            EditableValueHolder evh = (EditableValueHolder)c;
            String clientId = c.getClientId(faces);
            SavedState ss = this.getChildState().get(clientId);
            if (ss != null) {
                ss.apply(evh);
            } else {
                NullState.apply(evh);
            }
        }
        Iterator itr = c.getFacetsAndChildren();
        while (itr.hasNext()) {
            this.restoreChildState(faces, (UIComponent)itr.next());
        }
    }

    private boolean keepSaved(FacesContext context) {
        return this.hasErrorMessages(context) || this.isNestedInIterator();
    }

    private boolean hasErrorMessages(FacesContext context) {
        FacesMessage.Severity sev = context.getMaximumSeverity();
        return sev != null && FacesMessage.SEVERITY_ERROR.compareTo((Object)sev) >= 0;
    }

    private boolean isNestedInIterator() {
        for (UIComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIData) && !(parent instanceof UIRepeat)) continue;
            return true;
        }
        return false;
    }

    private void setIndex(FacesContext ctx, int index) {
        this.saveChildState(ctx);
        this.index = index;
        DataModel localModel = this.getDataModel();
        localModel.setRowIndex(index);
        if (this.index != -1 && this.var != null && localModel.isRowAvailable()) {
            Map attrs = ctx.getExternalContext().getRequestMap();
            attrs.put(this.var, localModel.getRowData());
        }
        this.restoreChildState(ctx);
    }

    private void updateIterationStatus(FacesContext ctx, IterationStatus status) {
        if (this.varStatus != null) {
            Map attrs = ctx.getExternalContext().getRequestMap();
            attrs.put(this.varStatus, status);
        }
    }

    private boolean isIndexAvailable() {
        return this.getDataModel().isRowAvailable();
    }

    public void process(FacesContext faces, PhaseId phase) {
        if (!this.isRendered()) {
            return;
        }
        this.resetDataModel();
        if (PhaseId.RENDER_RESPONSE.equals(phase) && !this.hasErrorMessages(faces)) {
            this.clearChildState();
        }
        this.captureOrigValue(faces);
        this.setIndex(faces, -1);
        try {
            if (this.getChildCount() > 0) {
                Integer size;
                Integer begin = this.getBegin();
                Integer step = this.getStep();
                Integer end = this.getEnd();
                Integer offset = this.getOffset();
                if (null != offset && offset > 0) {
                    begin = offset;
                }
                if (null != (size = this.getSize())) {
                    end = size;
                }
                String rendererType = this.getRendererType();
                Renderer renderer = null;
                if (rendererType != null) {
                    renderer = this.getRenderer(faces);
                }
                int rowCount = this.getDataModel().getRowCount();
                int i = begin != null ? begin : 0;
                int e = end != null ? end : rowCount;
                int s = step != null ? step : 1;
                this.validateIterationControlValues(rowCount, i, e);
                if (null != size && size > 0) {
                    e = size - 1;
                }
                this.setIndex(faces, i);
                this.updateIterationStatus(faces, new IterationStatus(true, i + s > e || rowCount == 1, i, begin, end, step));
                while (i <= e && this.isIndexAvailable()) {
                    if (PhaseId.RENDER_RESPONSE.equals(phase) && renderer != null) {
                        renderer.encodeChildren(faces, (UIComponent)this);
                    } else {
                        for (UIComponent c : this.getChildren()) {
                            if (PhaseId.APPLY_REQUEST_VALUES.equals(phase)) {
                                c.processDecodes(faces);
                                continue;
                            }
                            if (PhaseId.PROCESS_VALIDATIONS.equals(phase)) {
                                c.processValidators(faces);
                                continue;
                            }
                            if (PhaseId.UPDATE_MODEL_VALUES.equals(phase)) {
                                c.processUpdates(faces);
                                continue;
                            }
                            if (!PhaseId.RENDER_RESPONSE.equals(phase)) continue;
                            c.encodeAll(faces);
                        }
                    }
                    this.setIndex(faces, i += s);
                    this.updateIterationStatus(faces, new IterationStatus(false, i + s >= e, i, begin, end, step));
                }
            }
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            this.setIndex(faces, -1);
            this.restoreOrigValue(faces);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeOnComponent(FacesContext faces, String clientId, ContextCallback callback) throws FacesException {
        String id = super.getClientId(faces);
        if (clientId.equals(id)) {
            this.pushComponentToEL(faces, (UIComponent)this);
            try {
                callback.invokeContextCallback(faces, (UIComponent)this);
            }
            finally {
                this.popComponentFromEL(faces);
            }
            return true;
        }
        if (clientId.startsWith(id)) {
            int prevIndex = this.index;
            int idxStart = clientId.indexOf(UIRepeat.getSeparatorChar((FacesContext)faces), id.length());
            if (idxStart != -1 && Character.isDigit(clientId.charAt(idxStart + 1))) {
                int idxEnd = clientId.indexOf(UIRepeat.getSeparatorChar((FacesContext)faces), idxStart + 1);
                if (idxEnd != -1) {
                    int newIndex = Integer.parseInt(clientId.substring(idxStart + 1, idxEnd));
                    boolean found = false;
                    try {
                        this.captureOrigValue(faces);
                        this.setIndex(faces, newIndex);
                        if (this.isIndexAvailable()) {
                            found = super.invokeOnComponent(faces, clientId, callback);
                        }
                    }
                    finally {
                        this.setIndex(faces, prevIndex);
                        this.restoreOrigValue(faces);
                    }
                    return found;
                }
            } else {
                return super.invokeOnComponent(faces, clientId, callback);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        block12: {
            if (!this.isVisitable(context)) {
                return false;
            }
            FacesContext facesContext = context.getFacesContext();
            boolean visitRows = this.requiresRowIteration(context);
            int oldRowIndex = -1;
            if (visitRows) {
                oldRowIndex = this.getDataModel().getRowIndex();
                this.setIndex(facesContext, -1);
            }
            this.setDataModel(null);
            this.pushComponentToEL(facesContext, null);
            try {
                VisitResult result = context.invokeVisitCallback((UIComponent)this, callback);
                if (result == VisitResult.COMPLETE) {
                    boolean bl = true;
                    return bl;
                }
                if (result != VisitResult.ACCEPT || !this.doVisitChildren(context)) break block12;
                if (!visitRows) {
                    for (UIComponent kid : this.getChildren()) {
                        if (!kid.visitTree(context, callback)) continue;
                        boolean bl = true;
                        return bl;
                    }
                    break block12;
                }
                if (this.visitChildren(context, callback)) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.popComponentFromEL(facesContext);
                if (visitRows) {
                    this.setIndex(facesContext, oldRowIndex);
                }
            }
        }
        return false;
    }

    private boolean requiresRowIteration(VisitContext ctx) {
        return !ctx.getHints().contains(VisitHint.SKIP_ITERATION);
    }

    private boolean doVisitChildren(VisitContext context) {
        this.setIndex(context.getFacesContext(), -1);
        Collection idsToVisit = context.getSubtreeIdsToVisit((UIComponent)this);
        assert (idsToVisit != null);
        return !idsToVisit.isEmpty();
    }

    private void validateIterationControlValues(int rowCount, int begin, int end) {
        if (rowCount == 0) {
            return;
        }
        if (begin > rowCount) {
            throw new FacesException("Iteration start index is greater than the number of available rows.");
        }
        if (begin > end) {
            throw new FacesException("Iteration start index is greater than the end index.");
        }
        if (end > rowCount) {
            throw new FacesException("Iteration end index is greater than the number of available rows.");
        }
    }

    private boolean visitChildren(VisitContext context, VisitCallback callback) {
        int i;
        Integer begin = this.getBegin();
        Integer end = this.getEnd();
        Integer step = this.getStep();
        int rowCount = this.getDataModel().getRowCount();
        int e = end != null ? end : rowCount;
        int s = step != null ? step : 1;
        this.validateIterationControlValues(rowCount, i, e);
        FacesContext faces = context.getFacesContext();
        this.setIndex(faces, i);
        this.updateIterationStatus(faces, new IterationStatus(true, i + s > e || rowCount == 1, i, begin, end, step));
        for (i = begin != null ? begin : 0; i <= e && this.isIndexAvailable(); i += s) {
            this.setIndex(faces, i);
            this.updateIterationStatus(faces, new IterationStatus(false, i + s >= e, i, begin, end, step));
            for (UIComponent kid : this.getChildren()) {
                if (!kid.visitTree(context, callback)) continue;
                return true;
            }
        }
        return false;
    }

    public void processDecodes(FacesContext faces) {
        if (!this.isRendered()) {
            return;
        }
        this.setDataModel(null);
        if (!this.keepSaved(faces)) {
            this.childState = null;
        }
        this.process(faces, PhaseId.APPLY_REQUEST_VALUES);
        this.decode(faces);
    }

    public void processUpdates(FacesContext faces) {
        if (!this.isRendered()) {
            return;
        }
        this.resetDataModel();
        this.process(faces, PhaseId.UPDATE_MODEL_VALUES);
    }

    public void processValidators(FacesContext faces) {
        if (!this.isRendered()) {
            return;
        }
        this.resetDataModel();
        Application app = faces.getApplication();
        app.publishEvent(faces, PreValidateEvent.class, (Object)this);
        this.process(faces, PhaseId.PROCESS_VALIDATIONS);
        app.publishEvent(faces, PostValidateEvent.class, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof IndexedEvent) {
            IndexedEvent idxEvent = (IndexedEvent)event;
            this.resetDataModel();
            int prevIndex = this.index;
            FacesContext ctx = FacesContext.getCurrentInstance();
            FacesEvent target = idxEvent.getTarget();
            UIComponent source = target.getComponent();
            UIComponent compositeParent = null;
            try {
                int rowCount = this.getDataModel().getRowCount();
                int idx = idxEvent.getIndex();
                this.setIndex(ctx, idx);
                Integer begin = this.getBegin();
                Integer end = this.getEnd();
                Integer step = this.getStep();
                int b = begin != null ? begin : 0;
                int e = end != null ? end : rowCount;
                int s = step != null ? step : 1;
                this.updateIterationStatus(ctx, new IterationStatus(idx == b, idx + s >= e || rowCount == 1, idx, begin, end, step));
                if (!this.isIndexAvailable()) return;
                if (!UIComponent.isCompositeComponent((UIComponent)source)) {
                    compositeParent = UIComponent.getCompositeComponentParent((UIComponent)source);
                }
                if (compositeParent != null) {
                    compositeParent.pushComponentToEL(ctx, null);
                }
                source.pushComponentToEL(ctx, null);
                source.broadcast(target);
                return;
            }
            finally {
                source.popComponentFromEL(ctx);
                if (compositeParent != null) {
                    compositeParent.popComponentFromEL(ctx);
                }
                this.updateIterationStatus(ctx, null);
                this.setIndex(ctx, prevIndex);
            }
        } else {
            super.broadcast(event);
        }
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent((FacesEvent)new IndexedEvent(this, event, this.index));
    }

    public void restoreState(FacesContext faces, Object object) {
        if (faces == null) {
            throw new NullPointerException();
        }
        if (object == null) {
            return;
        }
        Object[] state = (Object[])object;
        super.restoreState(faces, state[0]);
        this.childState = (Map)state[1];
        this.begin = (Integer)state[2];
        this.end = (Integer)state[3];
        this.step = (Integer)state[4];
        this.var = (String)state[5];
        this.varStatus = (String)state[6];
        this.value = state[7];
    }

    public Object saveState(FacesContext faces) {
        if (faces == null) {
            throw new NullPointerException();
        }
        Object[] state = new Object[]{super.saveState(faces), this.childState, this.begin, this.end, this.step, this.var, this.varStatus, this.value};
        return state;
    }

    public void encodeChildren(FacesContext faces) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        this.setDataModel(null);
        if (!this.keepSaved(faces)) {
            this.childState = null;
        }
        this.process(faces, PhaseId.RENDER_RESPONSE);
    }

    public boolean getRendersChildren() {
        Renderer renderer;
        if (this.getRendererType() != null && (renderer = this.getRenderer(this.getFacesContext())) != null) {
            return renderer.getRendersChildren();
        }
        return true;
    }

    private static final class IndexedEvent
    extends FacesEvent {
        private final FacesEvent target;
        private final int index;

        public IndexedEvent(UIRepeat owner, FacesEvent target, int index) {
            super((UIComponent)owner);
            this.target = target;
            this.index = index;
        }

        public PhaseId getPhaseId() {
            return this.target.getPhaseId();
        }

        public void setPhaseId(PhaseId phaseId) {
            this.target.setPhaseId(phaseId);
        }

        public boolean isAppropriateListener(FacesListener listener) {
            return this.target.isAppropriateListener(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processListener(FacesListener listener) {
            UIRepeat owner = (UIRepeat)this.getComponent();
            int prevIndex = owner.index;
            FacesContext ctx = FacesContext.getCurrentInstance();
            try {
                owner.setIndex(ctx, this.index);
                if (owner.isIndexAvailable()) {
                    this.target.processListener(listener);
                }
            }
            finally {
                owner.setIndex(ctx, prevIndex);
            }
        }

        public int getIndex() {
            return this.index;
        }

        public FacesEvent getTarget() {
            return this.target;
        }
    }

    private static final class SavedState
    implements Serializable {
        private Object submittedValue;
        private static final long serialVersionUID = 2920252657338389849L;
        private boolean valid = true;
        private Object value;
        private boolean localValueSet;

        private SavedState() {
        }

        Object getSubmittedValue() {
            return this.submittedValue;
        }

        void setSubmittedValue(Object submittedValue) {
            this.submittedValue = submittedValue;
        }

        boolean isValid() {
            return this.valid;
        }

        void setValid(boolean valid) {
            this.valid = valid;
        }

        Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        boolean isLocalValueSet() {
            return this.localValueSet;
        }

        public void setLocalValueSet(boolean localValueSet) {
            this.localValueSet = localValueSet;
        }

        public String toString() {
            return "submittedValue: " + this.submittedValue + " value: " + this.value + " localValueSet: " + this.localValueSet;
        }

        public void populate(EditableValueHolder evh) {
            this.value = evh.getValue();
            this.valid = evh.isValid();
            this.submittedValue = evh.getSubmittedValue();
            this.localValueSet = evh.isLocalValueSet();
        }

        public void apply(EditableValueHolder evh) {
            evh.setValue(this.value);
            evh.setValid(this.valid);
            evh.setSubmittedValue(this.submittedValue);
            evh.setLocalValueSet(this.localValueSet);
        }
    }
}

